# ComfyUI LoRA Metadata Scraper

This is a Python tool that scans a ComfyUI installation and extracts metadata from `.safetensors` files, including LoRAs, checkpoints, VAEs, and ControlNets. It supports both local metadata extraction and optional scraping of CivitAI metadata, including preview images and videos.

What it does:
- Extracts embedded metadata from any `.safetensors` file
- Optionally scrapes CivitAI to fetch trigger words, tags, and descriptions
- Downloads preview images and videos from CivitAI
- Avoids redundant downloads by checking if metadata or previews already exist
- Supports both interactive and command-line usage
- Lets you choose to scan only LoRA files or your entire ComfyUI models folder
- Can save preview images/videos in a subdirectory or directly next to the model file
- Lets you set how many preview images/videos to download (or skip them entirely)

--------------------

## Folder Setup

Place everything inside:

ComfyUI/utils/Scrapertool/

Example structure:

ComfyUI/
└── utils/
    └── Scrapertool/
        ├── scraper_run.py
        ├── requirements.txt
        └── start.bat  (optional launcher)

--------------------

## Usage

### Option 1: Interactive Mode

Run:

python scraper_run.py --interactive

You’ll be prompted with:

A) Scrape CivitAI? (Y/N)
B) Use default delay (0.5s), no delay (0), or custom delay?
C) Force re-scrape if metadata already exists? (Y/N)
D) Scan only the LoRAs folder? (Y/N)
E) Save previews in a subdirectory? (Y/N)
F) How many preview images/videos to download? (A=All, N=None, or a number)

### Option 2: Command Line Arguments

Example:

python scrape_metadata_recursive.py --scrape-civitai --delay 0.5 --force --loras-only --previews-subdir --max-media 5

--------------------

## Command-Line Argument Reference

--interactive
    Launch the interactive menu.

--scrape-civitai
    Enable scraping of metadata and previews from CivitAI.

--delay [seconds]
    Set the delay between API calls and image/video downloads (default: 0.5 seconds).

--force
    Force re-scraping even if a metadata JSON already exists.

--loras-only
    Scan only the ComfyUI/models/loras folder. If omitted, scans all subdirectories.

--previews-subdir
    Save previews inside a dedicated subdirectory (e.g., model_previews/).

--no-previews-subdir
    Save previews directly next to the model file.

--max-media [number]
    Set how many preview images/videos to download. Use 0 to skip all. (Default: unlimited)

--------------------

## Dependencies

This script requires the following Python packages:

safetensors
torch
requests
tqdm

--------------------

## How to Set Up

1. Create a virtual environment (optional but recommended):

   python -m venv scrapervenv

2. Activate the virtual environment:

   On Windows:
   scrapervenv\Scripts\activate

   On macOS/Linux:
   source scrapervenv/bin/activate

3. Install dependencies:

   pip install -r requirements.txt

--------------------

## requirements.txt

safetensors
torch
requests
tqdm

--------------------

## License

Creative Commons Attribution 4.0 International (CC BY 4.0)

This tool is free to use, share, and adapt for any purpose, including commercial, as long as you provide attribution to the original creator.




