/*
 * Decompiled with CFR 0.152.
 */
package amten.ml;

import amten.ml.DataLoader;
import java.io.Serializable;

public class NNParams
implements Serializable {
    public int[] numCategories = null;
    public int numClasses = 1;
    public int numInputChannels = 1;
    public int inputWidth = 0;
    public NNLayerParams[] hiddenLayerParams = new NNLayerParams[]{new NNLayerParams(100)};
    public double weightPenalty = 1.0E-8;
    public double learningRate = 0.0;
    public int batchSize = 0;
    public int maxIterations = 1000;
    public int numThreads = 0;
    public double inputLayerDropoutRate = 0.2;
    public double hiddenLayersDropoutRate = 0.5;
    public boolean debug = true;
    public boolean normalizeNumericData = true;
    public double convergenceThreshold = 0.02;
    public transient DataLoader dataLoader = null;

    public static class NNLayerParams
    implements Serializable {
        public int numFeatures = 0;
        public int patchWidth = 0;
        public int patchHeight = 0;
        public int poolWidth = 0;
        public int poolHeight = 0;

        public NNLayerParams(int numFeatures) {
            this.numFeatures = numFeatures;
        }

        public NNLayerParams(int numFeatures, int patchWidth, int patchHeight, int poolWidth, int poolHeight) {
            this.numFeatures = numFeatures;
            this.patchWidth = patchWidth;
            this.patchHeight = patchHeight;
            this.poolWidth = poolWidth;
            this.poolHeight = poolHeight;
        }

        public boolean isConvolutional() {
            return this.patchWidth > 0 && this.patchHeight > 0;
        }

        public boolean isPooled() {
            return this.poolWidth > 1 || this.poolHeight > 1;
        }
    }
}

