/*
 * Decompiled with CFR 0.152.
 */
package amten.ml;

import amten.ml.Convolutions;
import amten.ml.NNParams;
import amten.ml.matrix.Matrix;
import amten.ml.matrix.MatrixElement;
import amten.ml.matrix.MatrixUtils;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class NeuralNetwork
implements Serializable {
    private NNParams myParams = null;
    private Matrix[] myThetas = null;
    private boolean mySoftmax = false;
    private int myInputHeight = 0;
    private int myNumOutputs = 0;
    private NNParams.NNLayerParams[] myLayerParams = null;
    private double[] myAverages = null;
    private double[] myStdDevs = null;
    private final transient ReentrantReadWriteLock myThetasLock = new ReentrantReadWriteLock();
    private transient ExecutorService myExecutorService;

    public NeuralNetwork(NNParams p) {
        this.myParams = p;
        this.myParams.debug = false;
    }

    public void train(Matrix x, Matrix y) throws Exception {
        int inputSize;
        if (this.myParams.numCategories == null) {
            this.myParams.numCategories = new int[x.numColumns()];
            Arrays.fill(this.myParams.numCategories, 1);
        }
        this.mySoftmax = this.myParams.numClasses > 1;
        this.myNumOutputs = this.myParams.numClasses > 1 ? this.myParams.numClasses : y.numColumns();
        this.myLayerParams = new NNParams.NNLayerParams[this.myParams.hiddenLayerParams.length + 2];
        System.arraycopy(this.myParams.hiddenLayerParams, 0, this.myLayerParams, 1, this.myParams.hiddenLayerParams.length);
        this.myLayerParams[this.myLayerParams.length - 1] = new NNParams.NNLayerParams(this.myNumOutputs);
        if (this.myParams.normalizeNumericData) {
            if (this.myParams.dataLoader != null) {
                throw new Exception("With load on demand, data must be normalized before being sent to NeuralNetwork.");
            }
            x = x.copy();
            this.myAverages = new double[x.numColumns()];
            this.myStdDevs = new double[x.numColumns()];
            int col = 0;
            while (col < x.numColumns()) {
                if (this.myParams.numCategories[col] <= 1) {
                    this.myAverages[col] = MatrixUtils.getAverage(x, col);
                    this.myStdDevs[col] = MatrixUtils.getStandardDeviation(x, col);
                    MatrixUtils.normalizeData(x, col, this.myAverages[col], this.myStdDevs[col]);
                }
                ++col;
            }
        } else {
            this.myAverages = null;
            this.myStdDevs = null;
        }
        x = MatrixUtils.expandNominalAttributes(x, this.myParams.numCategories);
        if (this.mySoftmax) {
            y = MatrixUtils.expandNominalAttributes(y, new int[]{this.myNumOutputs});
        }
        int n = inputSize = this.myParams.dataLoader == null ? x.numColumns() : this.myParams.dataLoader.getDataSize();
        if (this.myLayerParams[1].isConvolutional()) {
            int n2 = this.myParams.numInputChannels = this.myParams.numInputChannels > 0 ? this.myParams.numInputChannels : 1;
            if (this.myParams.inputWidth == 0) {
                this.myParams.inputWidth = (int)Math.sqrt(inputSize / this.myParams.numInputChannels);
                this.myInputHeight = (int)Math.sqrt(inputSize / this.myParams.numInputChannels);
            } else {
                this.myInputHeight = inputSize / (this.myParams.numInputChannels * this.myParams.inputWidth);
            }
        } else {
            this.myParams.inputWidth = inputSize;
        }
        if (this.myParams.batchSize == 0) {
            this.myParams.batchSize = this.myLayerParams[1].isConvolutional() ? 1 : 100;
        }
        this.initThetas();
        this.myParams.numThreads = this.myParams.numThreads > 0 ? this.myParams.numThreads : Runtime.getRuntime().availableProcessors();
        this.myExecutorService = Executors.newFixedThreadPool(this.myParams.numThreads);
        Reader keyboardReader = System.console() != null ? System.console().reader() : null;
        boolean halted = false;
        ArrayList<Matrix> batchesX = new ArrayList<Matrix>();
        ArrayList<Matrix> batchesY = new ArrayList<Matrix>();
        MatrixUtils.split(x, y, this.myParams.batchSize, batchesX, batchesY);
        if (this.myParams.learningRate == 0.0) {
            this.myParams.learningRate = this.findInitialLearningRate(x, y, this.myParams.batchSize, this.myParams.weightPenalty, this.myParams.debug);
        }
        double cost = this.getCostThreaded(batchesX, batchesY, this.myParams.weightPenalty);
        LinkedList<Double> fiveLastCosts = new LinkedList<Double>();
        LinkedList<Double> tenLastCosts = new LinkedList<Double>();
        if (this.myParams.debug) {
            System.out.println("\n\n*** Training network. Press <enter> to halt. ***\n");
        }
        int i = 0;
        while (i < this.myParams.maxIterations && !halted) {
            MatrixUtils.split(x, y, this.myParams.batchSize, batchesX, batchesY);
            this.trainOneIterationThreaded(batchesX, batchesY, this.myParams.learningRate, this.myParams.weightPenalty);
            cost = this.getCostThreaded(batchesX, batchesY, this.myParams.weightPenalty);
            if (fiveLastCosts.size() == 5) {
                double oldCost = (Double)fiveLastCosts.remove();
                double minCost = Math.min(cost, (Double)Collections.min(fiveLastCosts));
                if (minCost >= oldCost) {
                    this.myParams.learningRate *= 0.1;
                    fiveLastCosts.clear();
                }
            }
            if (tenLastCosts.size() == 10) {
                double minCost = Math.min(cost, (Double)Collections.min(tenLastCosts));
                double maxCost = Math.max(cost, (Double)Collections.max(tenLastCosts));
                tenLastCosts.remove();
                if ((maxCost - minCost) / minCost < this.myParams.convergenceThreshold) {
                    halted = true;
                }
            }
            if (this.myParams.debug) {
                // empty if block
            }
            fiveLastCosts.add(cost);
            tenLastCosts.add(cost);
            if (this.myParams.debug && System.in.available() > 0) {
                while (System.in.available() > 0) {
                    System.in.read();
                }
                System.out.println("Training halted by user.");
                halted = true;
            }
            ++i;
        }
        this.myExecutorService.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public Matrix getPredictions(Matrix x) throws Exception {
        if (this.myAverages != null) {
            x = x.copy();
            int col = 0;
            while (col < x.numColumns()) {
                if (this.myParams.numCategories[col] <= 1) {
                    MatrixUtils.normalizeData(x, col, this.myAverages[col], this.myStdDevs[col]);
                }
                ++col;
            }
        }
        if ((x = MatrixUtils.expandNominalAttributes(x, this.myParams.numCategories)).numRows() > this.myParams.batchSize) {
            void var5_8;
            final Matrix predictions = new Matrix(x.numRows(), this.myNumOutputs);
            ExecutorService es = Executors.newFixedThreadPool(this.myParams.numThreads);
            ArrayList queuedJobs = new ArrayList();
            boolean bl = false;
            while (var5_8 < x.numRows()) {
                void startRow = var5_8;
                int endRow = Math.min((int)(startRow + this.myParams.batchSize - true), x.numRows() - 1);
                final Matrix batchX = x.getRows((int)startRow, endRow);
                Runnable predictionsCalculator = new Runnable((int)startRow){
                    private final /* synthetic */ int val$startRow;
                    {
                        this.val$startRow = n;
                    }

                    @Override
                    public void run() {
                        FeedForwardResult[] ffRes = NeuralNetwork.this.feedForward(batchX, null);
                        Matrix batchPredictions = ffRes[ffRes.length - 1].output;
                        int batchRow = 0;
                        while (batchRow < batchPredictions.numRows()) {
                            int batchCol = 0;
                            while (batchCol < batchPredictions.numColumns()) {
                                predictions.set(this.val$startRow + batchRow, batchCol, batchPredictions.get(batchRow, batchCol));
                                ++batchCol;
                            }
                            ++batchRow;
                        }
                    }
                };
                queuedJobs.add(es.submit(predictionsCalculator));
                var5_8 += this.myParams.batchSize;
            }
            for (Future future : queuedJobs) {
                future.get();
            }
            es.shutdown();
            return predictions;
        }
        FeedForwardResult[] res = this.feedForward(x, null);
        return res[res.length - 1].output;
    }

    public int[] getPredictedClasses(Matrix x) throws Exception {
        Matrix y = this.getPredictions(x);
        int[] predictedClasses = new int[x.numRows()];
        int row = 0;
        while (row < y.numRows()) {
            int prediction = 0;
            double predMaxValue = -1.0;
            int col = 0;
            while (col < y.numColumns()) {
                if (y.get(row, col) > predMaxValue) {
                    predMaxValue = y.get(row, col);
                    prediction = col;
                }
                ++col;
            }
            predictedClasses[row] = prediction;
            ++row;
        }
        return predictedClasses;
    }

    private Matrix createTheta(int rows, int cols) {
        Matrix theta = MatrixUtils.random(rows, cols);
        double epsilon = Math.sqrt(6.0) / Math.sqrt(rows + cols);
        theta.scale(epsilon * 2.0);
        theta.add(-epsilon);
        int row = 0;
        while (row < theta.numRows()) {
            theta.set(row, 0, epsilon);
            ++row;
        }
        return theta;
    }

    private void initThetas() {
        ArrayList<Matrix> thetas = new ArrayList<Matrix>();
        int numLayers = this.myLayerParams.length;
        thetas.add(null);
        int layer = 1;
        while (layer < numLayers) {
            if (this.myLayerParams[layer].isConvolutional()) {
                int previousLayerNumFeatureMaps = layer > 1 ? this.myLayerParams[layer - 1].numFeatures : this.myParams.numInputChannels;
                int numFeatureMaps = this.myLayerParams[layer].numFeatures;
                int patchSize = this.myLayerParams[layer].patchWidth * this.myLayerParams[layer].patchHeight;
                thetas.add(this.createTheta(numFeatureMaps, previousLayerNumFeatureMaps * patchSize + 1));
            } else {
                int layerInputs = layer - 1 == 0 ? this.getWidth(0) + 1 : (this.myLayerParams[layer - 1].isConvolutional() ? this.myLayerParams[layer - 1].numFeatures * this.getWidth(layer - 1) * this.getHeight(layer - 1) + 1 : this.myLayerParams[layer - 1].numFeatures + 1);
                int layerOutputs = this.myLayerParams[layer].numFeatures;
                thetas.add(this.createTheta(layerOutputs, layerInputs));
            }
            ++layer;
        }
        this.myThetas = thetas.toArray(new Matrix[thetas.size()]);
    }

    private FeedForwardResult[] feedForward(Matrix x, Matrix[] dropoutMasks) {
        if (this.myParams.dataLoader != null) {
            try {
                x = this.myParams.dataLoader.loadData(x);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int numExamples = x.numRows();
        int numLayers = this.myLayerParams.length;
        FeedForwardResult[] ffr = new FeedForwardResult[numLayers];
        ffr[0] = new FeedForwardResult();
        ffr[0].output = x.copy();
        int layer = 1;
        while (layer < numLayers) {
            ffr[layer] = new FeedForwardResult();
            if (this.myLayerParams[layer].isConvolutional()) {
                int patchWidth = this.myLayerParams[layer].patchWidth;
                int patchHeight = this.myLayerParams[layer].patchHeight;
                int poolWidth = this.myLayerParams[layer].poolWidth;
                int poolHeight = this.myLayerParams[layer].poolHeight;
                ffr[layer].input = layer == 1 ? Convolutions.generatePatchesFromInputLayer(ffr[layer - 1].output, this.getWidth(layer - 1), this.getHeight(layer - 1), patchWidth, patchHeight) : Convolutions.generatePatchesFromHiddenLayer(ffr[layer - 1].output, this.getWidth(layer - 1), this.getHeight(layer - 1), patchWidth, patchHeight);
                ffr[layer].input = MatrixUtils.addBiasColumn(ffr[layer].input);
                ffr[layer].output = ffr[layer].input.trans2mult(this.myThetas[layer]);
                if (this.myLayerParams[layer].isPooled()) {
                    Convolutions.PoolingResult pr = Convolutions.maxPool(ffr[layer].output, this.getWidth(layer - 1) - patchWidth + 1, this.getHeight(layer - 1) - patchHeight + 1, poolWidth, poolHeight);
                    ffr[layer].numRowsPrePool = ffr[layer].output.numRows();
                    ffr[layer].output = pr.pooledActivations;
                    ffr[layer].prePoolRowIndexes = pr.prePoolRowIndexes;
                }
            } else {
                if (layer > 1 && this.myLayerParams[layer - 1].isConvolutional()) {
                    int numPatches = this.getWidth(layer - 1) * this.getHeight(layer - 1);
                    int numFeatureMaps = this.myLayerParams[layer - 1].numFeatures;
                    ffr[layer - 1].output = Convolutions.movePatchesToColumns(ffr[layer - 1].output, numExamples, numFeatureMaps, numPatches);
                }
                if (dropoutMasks != null && dropoutMasks[layer - 1] != null) {
                    ffr[layer - 1].output.multElements(dropoutMasks[layer - 1], ffr[layer - 1].output);
                } else {
                    double dropoutRate;
                    double d = dropoutRate = layer - 1 == 0 ? this.myParams.inputLayerDropoutRate : this.myParams.hiddenLayersDropoutRate;
                    if (dropoutRate > 0.0) {
                        ffr[layer - 1].output.scale(1.0 - dropoutRate);
                    }
                }
                ffr[layer].input = MatrixUtils.addBiasColumn(ffr[layer - 1].output);
                ffr[layer].output = ffr[layer].input.trans2mult(this.myThetas[layer]);
            }
            if (layer < numLayers - 1) {
                MatrixUtils.rectify(ffr[layer].output);
            } else if (this.mySoftmax) {
                MatrixUtils.softmax(ffr[layer].output);
            }
            ++layer;
        }
        return ffr;
    }

    private int numberOfNodes() {
        int nodes = 0;
        int t = 1;
        while (t < this.myThetas.length) {
            nodes += (this.myThetas[t].numColumns() - 1) * this.myThetas[t].numRows();
            ++t;
        }
        return nodes;
    }

    private double getCost(Matrix x, Matrix y, double weightPenalty, int batchSize) {
        double c = 0.0;
        FeedForwardResult[] ffr = this.feedForward(x, null);
        Matrix h = ffr[ffr.length - 1].output;
        if (this.mySoftmax) {
            int row = 0;
            while (row < y.numRows()) {
                int col = 0;
                while (col < y.numColumns()) {
                    if (y.get(row, col) > 0.99) {
                        c -= Math.log(h.get(row, col));
                    }
                    ++col;
                }
                ++row;
            }
            c /= (double)batchSize;
        } else {
            Matrix t1 = h.copy().add(-1.0, y);
            t1.multElements(t1, t1);
            for (MatrixElement me : t1) {
                c += me.value();
            }
            c /= (double)(2 * batchSize);
        }
        if (weightPenalty > 0.0) {
            double regSum = 0.0;
            int t = 1;
            while (t < this.myThetas.length) {
                for (MatrixElement me : this.myThetas[t].getColumns(1, -1)) {
                    regSum += Math.abs(me.value());
                }
                ++t;
            }
            c += regSum * weightPenalty / (double)this.numberOfNodes();
        }
        return c;
    }

    private double getCostThreaded(List<Matrix> batchesX, List<Matrix> batchesY, final double weightPenalty) throws Exception {
        final int batchSize = batchesX.get(0).numRows();
        ArrayList<Future<Double>> costJobs = new ArrayList<Future<Double>>();
        int batchNr = 0;
        while (batchNr < batchesX.size()) {
            final Matrix bx = batchesX.get(batchNr);
            final Matrix matrix = batchesY.get(batchNr);
            Callable<Double> costCalculator = new Callable<Double>(){

                @Override
                public Double call() throws Exception {
                    NeuralNetwork.this.myThetasLock.readLock().lock();
                    double cost = NeuralNetwork.this.getCost(bx, matrix, weightPenalty, batchSize);
                    NeuralNetwork.this.myThetasLock.readLock().unlock();
                    return cost;
                }
            };
            costJobs.add(this.myExecutorService.submit(costCalculator));
            ++batchNr;
        }
        double cost = 0.0;
        for (Future future : costJobs) {
            cost += ((Double)future.get()).doubleValue();
        }
        return cost /= (double)batchesX.size();
    }

    private Matrix[] getGradients(Matrix x, Matrix y, double weightPenalty, Matrix[] dropoutMasks, int batchSize) {
        int numLayers = this.myLayerParams.length;
        int numExamples = x.numRows();
        FeedForwardResult[] ffr = this.feedForward(x, dropoutMasks);
        Matrix[] delta = new Matrix[numLayers];
        delta[numLayers - 1] = ffr[numLayers - 1].output.copy().add(-1.0, y);
        int layer = numLayers - 2;
        while (layer >= 1) {
            delta[layer] = delta[layer + 1].mult(this.myThetas[layer + 1]).getColumns(1, -1);
            if (dropoutMasks != null && dropoutMasks[layer] != null) {
                delta[layer].multElements(dropoutMasks[layer], delta[layer]);
            }
            if (this.myLayerParams[layer].isConvolutional()) {
                int numFeatureMaps = this.myLayerParams[layer].numFeatures;
                int patchWidth = this.myLayerParams[layer].patchWidth;
                int patchHeight = this.myLayerParams[layer].patchHeight;
                if (!this.myLayerParams[layer + 1].isConvolutional()) {
                    int numPatches = this.getWidth(layer) * this.getHeight(layer);
                    delta[layer] = Convolutions.movePatchesToRows(delta[layer], numExamples, numFeatureMaps, numPatches);
                } else {
                    delta[layer] = Convolutions.antiPatchDeltas(delta[layer], this.getWidth(layer), this.getHeight(layer), patchWidth, patchHeight);
                }
                if (this.myLayerParams[layer].isPooled()) {
                    delta[layer] = Convolutions.antiPoolDelta(delta[layer], ffr[layer].prePoolRowIndexes, ffr[layer].numRowsPrePool);
                }
            }
            delta[layer].multElements(MatrixUtils.rectifyGradient(ffr[layer].input.trans2mult(this.myThetas[layer])), delta[layer]);
            --layer;
        }
        Matrix[] thetaGrad = new Matrix[numLayers];
        int layer2 = 1;
        while (layer2 < numLayers) {
            thetaGrad[layer2] = delta[layer2].trans1mult(ffr[layer2].input);
            thetaGrad[layer2].scale(1.0 / (double)batchSize);
            ++layer2;
        }
        if (weightPenalty > 0.0) {
            int numNodes = this.numberOfNodes();
            int thetaNr = 1;
            while (thetaNr < numLayers) {
                Matrix theta = this.myThetas[thetaNr];
                Matrix grad = thetaGrad[thetaNr];
                int row = 0;
                while (row < grad.numRows()) {
                    int col = 1;
                    while (col < grad.numColumns()) {
                        double regTerm = weightPenalty / (double)numNodes * Math.signum(theta.get(row, col));
                        grad.add(row, col, regTerm);
                        ++col;
                    }
                    ++row;
                }
                ++thetaNr;
            }
        }
        return thetaGrad;
    }

    private Matrix[] generateDropoutMasks(int numExamples) {
        Random rnd = new Random();
        int numLayers = this.myLayerParams.length;
        Matrix[] masks = new Matrix[numLayers - 1];
        int l = 0;
        while (l < masks.length) {
            if (!this.myLayerParams[l + 1].isConvolutional() && (l == 0 && this.myParams.inputLayerDropoutRate > 0.0 || l > 0 && this.myParams.hiddenLayersDropoutRate > 0.0)) {
                int numColumns = l == 0 ? this.getWidth(0) : this.myLayerParams[l].numFeatures * this.getWidth(l) * this.getHeight(l);
                Matrix mask = new Matrix(numExamples, numColumns);
                double dropoutRate = l == 0 ? this.myParams.inputLayerDropoutRate : this.myParams.hiddenLayersDropoutRate;
                for (MatrixElement me : mask) {
                    me.set(rnd.nextDouble() > dropoutRate ? 1.0 : 0.0);
                }
                masks[l] = mask;
            }
            ++l;
        }
        return masks;
    }

    /*
     * WARNING - void declaration
     */
    private void trainOneIterationThreaded(List<Matrix> batchesX, List<Matrix> batchesY, final double learningRate, final double weightPenalty) throws Exception {
        void var9_8;
        final int batchSize = batchesX.get(0).numRows();
        ArrayList queuedJobs = new ArrayList();
        boolean bl = false;
        while (var9_8 < batchesX.size()) {
            final Matrix bx = batchesX.get((int)var9_8);
            final Matrix by = batchesY.get((int)var9_8);
            Runnable batchGradientCalculator = new Runnable(){

                @Override
                public void run() {
                    boolean useDropout = ((NeuralNetwork)NeuralNetwork.this).myParams.inputLayerDropoutRate > 0.0 || ((NeuralNetwork)NeuralNetwork.this).myParams.hiddenLayersDropoutRate > 0.0;
                    Matrix[] dropoutMasks = useDropout ? NeuralNetwork.this.generateDropoutMasks(by.numRows()) : null;
                    NeuralNetwork.this.myThetasLock.readLock().lock();
                    Matrix[] gradients = NeuralNetwork.this.getGradients(bx, by, weightPenalty, dropoutMasks, batchSize);
                    NeuralNetwork.this.myThetasLock.readLock().unlock();
                    NeuralNetwork.this.myThetasLock.writeLock().lock();
                    int theta = 1;
                    while (theta < NeuralNetwork.this.myThetas.length) {
                        NeuralNetwork.this.myThetas[theta].add(-learningRate, gradients[theta]);
                        ++theta;
                    }
                    NeuralNetwork.this.myThetasLock.writeLock().unlock();
                }
            };
            queuedJobs.add(this.myExecutorService.submit(batchGradientCalculator));
            ++var9_8;
        }
        for (Future future : queuedJobs) {
            future.get();
        }
    }

    private Matrix[] deepCopy(Matrix[] ms) {
        Matrix[] res = new Matrix[ms.length];
        int i = 0;
        while (i < res.length) {
            res[i] = ms[i] != null ? ms[i].copy() : null;
            ++i;
        }
        return res;
    }

    private double findInitialLearningRate(Matrix x, Matrix y, int batchSize, double weightPenalty, boolean debug) throws Exception {
        int numUsedTrainingExamples = 5000;
        int numBatches = numUsedTrainingExamples / batchSize;
        List<Matrix> batchesX = new ArrayList<Matrix>();
        List<Matrix> batchesY = new ArrayList<Matrix>();
        MatrixUtils.split(x, y, batchSize, batchesX, batchesY);
        while (batchesX.size() < numBatches) {
            batchesX.addAll(batchesX);
            batchesY.addAll(batchesY);
        }
        if (batchesX.size() > numBatches) {
            batchesX = batchesX.subList(0, numBatches);
            batchesY = batchesY.subList(0, numBatches);
        }
        Matrix[] startThetas = this.deepCopy(this.myThetas);
        double lr = 1.0E-10;
        this.trainOneIterationThreaded(batchesX, batchesY, lr, weightPenalty);
        double cost = this.getCostThreaded(batchesX, batchesY, weightPenalty);
        this.myThetas = this.deepCopy(startThetas);
        double lastCost = Double.MAX_VALUE;
        double lastLR = lr;
        while (cost < lastCost) {
            lastCost = cost;
            lastLR = lr;
            this.trainOneIterationThreaded(batchesX, batchesY, lr *= 10.0, weightPenalty);
            cost = this.getCostThreaded(batchesX, batchesY, weightPenalty);
            this.myThetas = this.deepCopy(startThetas);
        }
        if (debug) {
            System.out.println("Using learning rate: " + String.format("%.1E", lastLR));
        }
        return lastLR;
    }

    private int getWidth(int layer) {
        if (layer > 0 && !this.myLayerParams[layer].isConvolutional()) {
            return 1;
        }
        int width = this.myParams.inputWidth;
        int l = 1;
        while (l <= layer) {
            int patchWidth = this.myLayerParams[l].patchWidth;
            int poolWidth = this.myLayerParams[l].poolWidth;
            width = (width = width - patchWidth + 1) % poolWidth == 0 ? width / poolWidth : width / poolWidth + 1;
            ++l;
        }
        return width;
    }

    private int getHeight(int layer) {
        if (layer > 0 && !this.myLayerParams[layer].isConvolutional()) {
            return 1;
        }
        int height = this.myInputHeight;
        int l = 1;
        while (l <= layer) {
            int patchHeight = this.myLayerParams[l].patchHeight;
            int poolHeight = this.myLayerParams[l].poolHeight;
            height = (height = height - patchHeight + 1) % poolHeight == 0 ? height / poolHeight : height / poolHeight + 1;
            ++l;
        }
        return height;
    }

    private static class FeedForwardResult {
        public Matrix input = null;
        public Matrix output = null;
        public Matrix prePoolRowIndexes = null;
        public int numRowsPrePool = 0;

        private FeedForwardResult() {
        }
    }
}

