/*
 * Decompiled with CFR 0.152.
 */
package amten.ml.matrix;

import amten.ml.matrix.MatrixElement;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.DenseMatrix;

public class Matrix
implements Iterable<MatrixElement>,
Serializable {
    private DenseMatrix myMatrix;

    public Matrix(int numRows, int numColumns) {
        this.myMatrix = new DenseMatrix(numRows, numColumns);
    }

    public Matrix(double[][] values) {
        this.myMatrix = new DenseMatrix(values);
    }

    private Matrix(DenseMatrix m) {
        this.myMatrix = m;
    }

    public int numRows() {
        return this.myMatrix.numRows();
    }

    public int numColumns() {
        return this.myMatrix.numColumns();
    }

    public Matrix copy() {
        DenseMatrix m = new DenseMatrix(this.numRows(), this.numColumns());
        System.arraycopy(this.myMatrix.getData(), 0, m.getData(), 0, m.getData().length);
        return new Matrix(m);
    }

    public double get(int row, int col) {
        return this.myMatrix.get(row, col);
    }

    public double[] getRow(int row) {
        double[] data = new double[this.numColumns()];
        int col = 0;
        while (col < this.numColumns()) {
            data[col] = this.get(row, col);
            ++col;
        }
        return data;
    }

    public double[] getCol(int col) {
        double[] data = new double[this.numRows()];
        int row = 0;
        while (row < this.numRows()) {
            data[row] = this.get(row, col);
            ++row;
        }
        return data;
    }

    public void set(int row, int col, double v) {
        this.myMatrix.set(row, col, v);
    }

    public void fill(double value) {
        Arrays.fill(this.myMatrix.getData(), value);
    }

    private void checkSize(Matrix m2) {
        if (this.numRows() != m2.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numRows (" + this.numRows() + " != " + m2.numRows() + ")");
        }
        if (this.numColumns() != m2.numColumns()) {
            throw new IndexOutOfBoundsException("A.numColumns != B.numColumns (" + this.numColumns() + " != " + m2.numColumns() + ")");
        }
    }

    public Matrix add(double c, Matrix m2) {
        this.checkSize(m2);
        double[] d = this.getData();
        double[] d2 = m2.getData();
        int i = 0;
        while (i < d.length) {
            int n = i;
            d[n] = d[n] + c * d2[i];
            ++i;
        }
        return this;
    }

    public Matrix add(double c) {
        double[] d = this.getData();
        int i = 0;
        while (i < d.length) {
            int n = i++;
            d[n] = d[n] + c;
        }
        return this;
    }

    public void add(int row, int col, double v) {
        this.set(row, col, this.get(row, col) + v);
    }

    public Matrix mult(Matrix m2) {
        return this.mult(m2, new Matrix(this.numRows(), m2.numColumns()));
    }

    public Matrix mult(Matrix m2, Matrix res) {
        this.myMatrix.mult((no.uib.cipr.matrix.Matrix)m2.myMatrix, (no.uib.cipr.matrix.Matrix)res.myMatrix);
        return res;
    }

    public Matrix multElements(Matrix m2) {
        return this.multElements(m2, new Matrix(this.numRows(), this.numColumns()));
    }

    public Matrix multElements(Matrix m2, Matrix res) {
        this.checkSize(m2);
        this.checkSize(res);
        double[] d = this.getData();
        double[] d2 = m2.getData();
        double[] dres = res.getData();
        int i = 0;
        while (i < d.length) {
            dres[i] = d[i] * d2[i];
            ++i;
        }
        return res;
    }

    public Matrix trans1mult(Matrix m2) {
        return this.trans1mult(m2, new Matrix(this.numColumns(), m2.numColumns()));
    }

    public Matrix trans1mult(Matrix m2, Matrix res) {
        this.myMatrix.transAmult((no.uib.cipr.matrix.Matrix)m2.myMatrix, (no.uib.cipr.matrix.Matrix)res.myMatrix);
        return res;
    }

    public Matrix trans2mult(Matrix m2) {
        return this.trans2mult(m2, new Matrix(this.numRows(), m2.numRows()));
    }

    public Matrix trans2mult(Matrix m2, Matrix res) {
        this.myMatrix.transBmult((no.uib.cipr.matrix.Matrix)m2.myMatrix, (no.uib.cipr.matrix.Matrix)res.myMatrix);
        return res;
    }

    public Matrix scale(double c) {
        double[] d = this.getData();
        int i = 0;
        while (i < d.length) {
            d[i] = d[i] * c;
            ++i;
        }
        return this;
    }

    public double[] getData() {
        return this.myMatrix.getData();
    }

    public Matrix addColumns(Matrix m2) {
        if (this.numRows() != m2.numRows()) {
            throw new IndexOutOfBoundsException("A.numRows != B.numRows (" + this.numRows() + " != " + m2.numRows() + ")");
        }
        double[] d1 = this.getData();
        double[] d2 = m2.getData();
        Matrix m3 = new Matrix(this.numRows(), this.numColumns() + m2.numColumns());
        double[] d3 = m3.getData();
        System.arraycopy(d1, 0, d3, 0, d1.length);
        System.arraycopy(d2, 0, d3, d1.length, d2.length);
        return m3;
    }

    public Matrix getColumns(int startCol, int endCol) {
        endCol = endCol == -1 ? this.numColumns() - 1 : endCol;
        Matrix m2 = new Matrix(this.numRows(), endCol - startCol + 1);
        System.arraycopy(this.myMatrix.getData(), startCol * this.numRows(), m2.getData(), 0, m2.getData().length);
        return m2;
    }

    public Matrix getRows(int startRow, int endRow) {
        endRow = endRow == -1 ? this.numRows() - 1 : endRow;
        Matrix m2 = new Matrix(endRow - startRow + 1, this.numColumns());
        int row = 0;
        while (row < m2.numRows()) {
            int col = 0;
            while (col < m2.numColumns()) {
                m2.set(row, col, this.get(row + startRow, col));
                ++col;
            }
            ++row;
        }
        return m2;
    }

    @Override
    public Iterator<MatrixElement> iterator() {
        return new Iterator<MatrixElement>(){
            private MatrixElement me;
            {
                this.me = new MatrixElement(Matrix.this);
            }

            @Override
            public boolean hasNext() {
                return this.me.myPos < this.me.myData.length - 1;
            }

            @Override
            public MatrixElement next() {
                ++this.me.myPos;
                return this.me;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Nope.");
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int row = 0;
        while (row < this.numRows()) {
            int col = 0;
            while (col < this.numColumns()) {
                sb.append(this.get(row, col)).append("  ");
                ++col;
            }
            sb.append("\n");
            ++row;
        }
        return sb.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.numRows());
        out.writeInt(this.numColumns());
        out.writeObject(this.getData());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.myMatrix = new DenseMatrix(in.readInt(), in.readInt());
        double[] data = (double[])in.readObject();
        System.arraycopy(data, 0, this.myMatrix.getData(), 0, data.length);
    }
}

