/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.ioclasses.potions;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import me.rockyhawk.commandpanels.CommandPanels;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ClassicPotionData {
    private CommandPanels plugin;

    public ClassicPotionData(CommandPanels plugin) {
        this.plugin = plugin;
    }

    public void applyPotionEffect(Player p, ItemStack item, String[] effectType) {
        try {
            if (item == null || item.getType() != Material.POTION) {
                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Item is not a potion."));
                return;
            }
            Class<?> potionClass = Class.forName("org.bukkit.potion.Potion");
            Class<?> potionTypeClass = Class.forName("org.bukkit.potion.PotionType");
            Object potionType = Enum.valueOf(potionTypeClass, effectType[0].toUpperCase());
            Constructor<?> potionConstructor = potionClass.getConstructor(potionTypeClass, Integer.TYPE);
            Object potion = potionConstructor.newInstance(potionType, effectType.length >= 3 && effectType[2].equalsIgnoreCase("true") ? 2 : 1);
            Method setSplashMethod = potionClass.getMethod("setSplash", Boolean.TYPE);
            boolean isSplash = (item.getDurability() & 0x4000) != 0;
            setSplashMethod.invoke(potion, isSplash);
            try {
                Method setHasExtendedDurationMethod = potionClass.getMethod("setHasExtendedDuration", Boolean.TYPE);
                setHasExtendedDurationMethod.invoke(potion, effectType.length >= 2 && effectType[1].equalsIgnoreCase("true"));
            }
            catch (Exception setHasExtendedDurationMethod) {
                // empty catch block
            }
            Method applyMethod = potionClass.getMethod("apply", ItemStack.class);
            applyMethod.invoke(potion, item);
        }
        catch (Exception er) {
            this.plugin.debug(er, p);
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + "Incorrect potion type or format."));
        }
    }

    public String retrievePotionData(ItemStack item) {
        try {
            if (item == null || item.getType() != Material.POTION) {
                return "Item is not a potion";
            }
            Class<?> potionClass = Class.forName("org.bukkit.potion.Potion");
            Method fromItemStackMethod = potionClass.getMethod("fromItemStack", ItemStack.class);
            Object potion = fromItemStackMethod.invoke(null, item);
            Method getTypeMethod = potionClass.getMethod("getType", new Class[0]);
            Method isExtendedMethod = potionClass.getMethod("hasExtendedDuration", new Class[0]);
            Method isUpgradedMethod = potionClass.getMethod("getLevel", new Class[0]);
            Object potionType = getTypeMethod.invoke(potion, new Object[0]);
            boolean extended = (Boolean)isExtendedMethod.invoke(potion, new Object[0]);
            boolean upgraded = (Integer)isUpgradedMethod.invoke(potion, new Object[0]) > 1;
            boolean isSplash = (item.getDurability() & 0x4000) != 0;
            return potionType.toString() + " " + extended + " " + upgraded + " Splash:" + isSplash;
        }
        catch (Exception e) {
            this.plugin.debug(e, null);
            return "Failed to retrieve potion data";
        }
    }
}

