/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.listeners;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.managers.MessagesManager;
import ce.ajneb97.model.CEEvent;
import ce.ajneb97.model.CustomEventProperties;
import ce.ajneb97.model.EventType;
import ce.ajneb97.model.StoredVariable;
import ce.ajneb97.model.internal.ConditionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;

public class CustomEventListener
implements Listener {
    public ConditionalEvents plugin;

    public CustomEventListener(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.configure();
    }

    public void configure() {
        ArrayList<CEEvent> validEvents = this.plugin.getEventsManager().getEventsByType(EventType.CUSTOM);
        for (CEEvent ceEvent : validEvents) {
            CustomEventProperties properties = ceEvent.getCustomEventProperties();
            String eventPackage = properties.getEventPackage();
            try {
                Class<?> eventClass = Class.forName(eventPackage);
                EventExecutor eventExecutor = (listener, event) -> this.executeEvent(event, ceEvent.getName());
                this.plugin.getServer().getPluginManager().registerEvent(eventClass, (Listener)this, EventPriority.MONITOR, eventExecutor, (Plugin)this.plugin);
            }
            catch (ClassNotFoundException ex) {
                Bukkit.getConsoleSender().sendMessage(ConditionalEvents.prefix + MessagesManager.getColoredMessage("&cClass " + eventPackage + " &cdoesn't exists for custom event &e" + ceEvent.getName() + "&c."));
            }
        }
    }

    public void executeEvent(Event event, String ceEventName) {
        Class<?> classObject = event.getClass();
        CEEvent ceEvent = this.plugin.getEventsManager().getEvent(ceEventName);
        if (ceEvent == null || !ceEvent.isEnabled()) {
            return;
        }
        CustomEventProperties properties = ceEvent.getCustomEventProperties();
        try {
            if (!Class.forName(properties.getEventPackage()).isAssignableFrom(classObject)) {
                return;
            }
        }
        catch (ClassNotFoundException e1) {
            e1.printStackTrace();
        }
        List<String> variablesToCapture = properties.getVariablesToCapture();
        ArrayList<StoredVariable> storedVariables = new ArrayList<StoredVariable>();
        for (String line : variablesToCapture) {
            String[] sepLine = line.split(";");
            String variable = sepLine[0];
            String methodName = sepLine[1].replace("(", "").replace(")", "");
            Object objectFinal = null;
            if (methodName.contains(".")) {
                objectFinal = this.getFinalObjectFromMultipleMethods(methodName, event, classObject);
            } else {
                Method m = this.obtainMethod(classObject, methodName);
                objectFinal = this.obtainObjectFromEvent(m, event);
            }
            if (objectFinal == null) continue;
            storedVariables.add(new StoredVariable(variable, objectFinal.toString()));
        }
        Object playerObjectFinal = null;
        if (properties.getPlayerVariable() != null) {
            String methodName = properties.getPlayerVariable().replace("(", "").replace(")", "");
            if (methodName.contains(".")) {
                playerObjectFinal = this.getFinalObjectFromMultipleMethods(methodName, event, classObject);
            } else {
                Method m = this.obtainMethod(classObject, methodName);
                playerObjectFinal = this.obtainObjectFromEvent(m, event);
            }
        }
        try {
            Player player = null;
            if (playerObjectFinal != null) {
                player = (Player)playerObjectFinal;
            }
            ConditionEvent conditionEvent = new ConditionEvent(this.plugin, player, event, EventType.CUSTOM, null).addVariables(storedVariables);
            this.plugin.getEventsManager().checkSingularEvent(conditionEvent, ceEvent);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object getFinalObjectFromMultipleMethods(String method, Event event, Class<?> classObject) {
        Object objectFinal = null;
        String[] methods = method.split("\\.");
        Class<?> newClass = classObject;
        try {
            for (int i = 0; i < methods.length; ++i) {
                String currentMethod = methods[i];
                Method m = this.obtainMethod(newClass, currentMethod);
                objectFinal = i == 0 ? this.obtainObjectFromEvent(m, event) : this.obtainObjectFromObject(m, objectFinal);
                newClass = objectFinal.getClass();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return objectFinal;
    }

    private Method obtainMethod(Class<?> classObject, String methodName) {
        try {
            return classObject.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object obtainObjectFromEvent(Method m, Event event) {
        try {
            return m.invoke((Object)event, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Object obtainObjectFromObject(Method m, Object object) {
        try {
            return m.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }
}

