/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_8to1_7_6_10.rewriter;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.viaversion.viarewind.ViaRewind;
import com.viaversion.viarewind.api.minecraft.entitydata.EntityDataTypes1_7_6_10;
import com.viaversion.viarewind.api.rewriter.VREntityRewriter;
import com.viaversion.viarewind.api.type.RewindTypes;
import com.viaversion.viarewind.api.type.version.Types1_7_6_10;
import com.viaversion.viarewind.protocol.v1_7_6_10to1_7_2_5.packet.ClientboundPackets1_7_2_5;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.Protocol1_8To1_7_6_10;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.data.EntityDataIndex1_7_6_10;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.data.VirtualHologramEntity;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.EntityTracker1_8;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.GameProfileStorage;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.PlayerSessionStorage;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.ScoreboardTracker;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_8;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityDataType;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_8;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.Types1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.rewriter.entitydata.EntityDataHandlerEvent;
import com.viaversion.viaversion.util.IdAndData;
import java.util.List;
import java.util.UUID;

public class EntityPacketRewriter1_8
extends VREntityRewriter<ClientboundPackets1_8, Protocol1_8To1_7_6_10> {
    public EntityPacketRewriter1_8(Protocol1_8To1_7_6_10 protocol) {
        super(protocol, EntityDataTypes1_7_6_10.STRING, EntityDataTypes1_7_6_10.BYTE);
    }

    protected void registerPackets() {
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.LOGIN, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map(Types.STRING);
                this.read((Type)Types.BOOLEAN);
                this.handler(EntityPacketRewriter1_8.this.playerTrackerHandler());
                this.handler(wrapper -> {
                    int entityId = (Integer)wrapper.get((Type)Types.INT, 0);
                    if (ViaRewind.getConfig().isReplaceAdventureMode() && (Short)wrapper.get((Type)Types.UNSIGNED_BYTE, 0) == 2) {
                        wrapper.set((Type)Types.UNSIGNED_BYTE, 0, (Object)0);
                    }
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    tracker.addPlayer(entityId, wrapper.user().getProtocolInfo().getUuid());
                    tracker.setClientEntityGameMode(((Short)wrapper.get((Type)Types.UNSIGNED_BYTE, 0)).shortValue());
                    ((ClientWorld)wrapper.user().get(ClientWorld.class)).setEnvironment((int)((Byte)wrapper.get((Type)Types.BYTE, 0)).byteValue());
                    wrapper.user().put((StorableObject)new ScoreboardTracker(wrapper.user()));
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.REMOVE_ENTITIES, wrapper -> {
            int[] entities = (int[])wrapper.read(Types.VAR_INT_ARRAY_PRIMITIVE);
            this.removeEntities(wrapper.user(), entities);
            wrapper.cancel();
            List parts = Lists.partition((List)Ints.asList((int[])entities), (int)127);
            for (List part : parts) {
                PacketWrapper destroy = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.REMOVE_ENTITIES, (UserConnection)wrapper.user());
                destroy.write(RewindTypes.INT_ARRAY, (Object)part.stream().mapToInt(Integer::intValue).toArray());
                destroy.scheduleSend(Protocol1_8To1_7_6_10.class);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_ENTITY_DATA, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map(Types1_8.ENTITY_DATA_LIST, Types1_7_6_10.ENTITY_DATA_LIST);
                this.handler(wrapper -> {
                    EntityTracker1_8 tracker = (EntityTracker1_8)EntityPacketRewriter1_8.this.tracker(wrapper.user());
                    int entityId = (Integer)wrapper.get((Type)Types.INT, 0);
                    List entityData = (List)wrapper.get(Types1_7_6_10.ENTITY_DATA_LIST, 0);
                    if (tracker.getHolograms().containsKey(entityId)) {
                        wrapper.cancel();
                        ((VirtualHologramEntity)tracker.getHolograms().get(entityId)).syncState(EntityPacketRewriter1_8.this, entityData);
                    } else if (tracker.hasEntity(entityId)) {
                        EntityPacketRewriter1_8.this.handleEntityData(entityId, entityData, wrapper.user());
                    } else {
                        wrapper.cancel();
                    }
                    if (tracker.clientEntityId() == entityId) {
                        tracker.updateEntityData(entityData);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ADD_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.INT);
                this.handler(EntityPacketRewriter1_8.this.getObjectTrackerHandler());
                this.handler(EntityPacketRewriter1_8.this.getObjectRewriter(EntityTypes1_8.ObjectType::findById));
                this.handler(wrapper -> {
                    byte by;
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    EntityTypes1_8.EntityType type = EntityTypes1_8.getTypeFromId((int)((Byte)wrapper.get((Type)Types.BYTE, 0)).byteValue(), (boolean)true);
                    int x = (Integer)wrapper.get((Type)Types.INT, 0);
                    int y = (Integer)wrapper.get((Type)Types.INT, 1);
                    int z = (Integer)wrapper.get((Type)Types.INT, 2);
                    byte pitch = (Byte)wrapper.get((Type)Types.BYTE, 1);
                    byte by2 = (Byte)wrapper.get((Type)Types.BYTE, 2);
                    int data = (Integer)wrapper.get((Type)Types.INT, 3);
                    if (type == EntityTypes1_8.ObjectType.ITEM_FRAME.getType()) {
                        by = switch (by2) {
                            case -128 -> {
                                z += 32;
                                yield 0;
                            }
                            case -64 -> {
                                x -= 32;
                                yield -64;
                            }
                            case 0 -> {
                                z -= 32;
                                yield -128;
                            }
                            case 64 -> {
                                x += 32;
                                yield 64;
                            }
                            default -> by2;
                        };
                    } else if (type == EntityTypes1_8.ObjectType.ARMOR_STAND.getType()) {
                        wrapper.cancel();
                        EntityTracker1_8 tracker = (EntityTracker1_8)EntityPacketRewriter1_8.this.tracker(wrapper.user());
                        VirtualHologramEntity hologram = (VirtualHologramEntity)tracker.getHolograms().get(entityId);
                        hologram.setPosition((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                        hologram.setRotation((float)by2 * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                        hologram.setHeadYaw((float)by2 * 360.0f / 256.0f);
                    } else if (type != null && type.isOrHasParent((EntityType)EntityTypes1_8.EntityType.FALLING_BLOCK)) {
                        int blockId = data & 0xFFF;
                        int blockData = data >> 12 & 0xF;
                        IdAndData replace = ((Protocol1_8To1_7_6_10)EntityPacketRewriter1_8.this.protocol).getItemRewriter().handleBlock(blockId, blockData);
                        if (replace != null) {
                            blockId = replace.getId();
                            blockData = replace.getData();
                        }
                        data = blockId | blockData << 16;
                        wrapper.set((Type)Types.INT, 3, (Object)data);
                    }
                    wrapper.set((Type)Types.INT, 0, (Object)x);
                    wrapper.set((Type)Types.INT, 1, (Object)y);
                    wrapper.set((Type)Types.INT, 2, (Object)z);
                    wrapper.set((Type)Types.BYTE, 2, (Object)by);
                    if (data > 0) {
                        wrapper.passthrough((Type)Types.SHORT);
                        wrapper.passthrough((Type)Types.SHORT);
                        wrapper.passthrough((Type)Types.SHORT);
                    }
                });
            }
        });
        this.registerTracker((ClientboundPacketType)ClientboundPackets1_8.ADD_EXPERIENCE_ORB, (EntityType)EntityTypes1_8.EntityType.EXPERIENCE_ORB);
        this.registerTracker((ClientboundPacketType)ClientboundPackets1_8.ADD_GLOBAL_ENTITY, (EntityType)EntityTypes1_8.EntityType.LIGHTNING_BOLT);
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ADD_PAINTING, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map(Types.STRING);
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.INT_POSITION);
                this.map((Type)Types.UNSIGNED_BYTE, (Type)Types.INT);
                this.handler(wrapper -> {
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    BlockPosition position = (BlockPosition)wrapper.get(RewindTypes.INT_POSITION, 0);
                    int rotation = (Integer)wrapper.get((Type)Types.INT, 0);
                    int modX = 0;
                    int modZ = 0;
                    switch (rotation) {
                        case 0: {
                            modZ = -1;
                            break;
                        }
                        case 1: {
                            modX = 1;
                            break;
                        }
                        case 2: {
                            modZ = 1;
                            break;
                        }
                        case 3: {
                            modX = -1;
                        }
                    }
                    wrapper.set(RewindTypes.INT_POSITION, 0, (Object)new BlockPosition(position.x() + modX, position.y(), position.z() + modZ));
                    EntityPacketRewriter1_8.this.addTrackedEntity(wrapper, entityId, (EntityType)EntityTypes1_8.EntityType.PAINTING);
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ADD_MOB, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.SHORT);
                this.map((Type)Types.SHORT);
                this.map((Type)Types.SHORT);
                this.map(Types1_8.ENTITY_DATA_LIST, Types1_7_6_10.ENTITY_DATA_LIST);
                this.handler(EntityPacketRewriter1_8.this.getTrackerHandler((Type)Types.UNSIGNED_BYTE, 0));
                this.handler(wrapper -> {
                    short typeId = (Short)wrapper.get((Type)Types.UNSIGNED_BYTE, 0);
                    EntityTypes1_8.EntityType type = EntityTypes1_8.getTypeFromId((int)typeId, (boolean)false);
                    if (type == EntityTypes1_8.EntityType.ARMOR_STAND) {
                        wrapper.cancel();
                        int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                        int x = (Integer)wrapper.get((Type)Types.INT, 0);
                        int y = (Integer)wrapper.get((Type)Types.INT, 1);
                        int z = (Integer)wrapper.get((Type)Types.INT, 2);
                        byte pitch = (Byte)wrapper.get((Type)Types.BYTE, 1);
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        byte headYaw = (Byte)wrapper.get((Type)Types.BYTE, 2);
                        EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                        VirtualHologramEntity hologram = (VirtualHologramEntity)tracker.getHolograms().get(entityId);
                        hologram.setPosition((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                        hologram.setRotation((float)yaw * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                        hologram.setHeadYaw((float)headYaw * 360.0f / 256.0f);
                        hologram.syncState(((Protocol1_8To1_7_6_10)EntityPacketRewriter1_8.this.protocol()).getEntityRewriter(), (List)wrapper.get(Types1_7_6_10.ENTITY_DATA_LIST, 0));
                    }
                });
                this.handler(EntityPacketRewriter1_8.this.getMobSpawnRewriter(Types1_7_6_10.ENTITY_DATA_LIST));
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ADD_PLAYER, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.handler(wrapper -> {
                    UUID uuid = (UUID)wrapper.read(Types.UUID);
                    wrapper.write(Types.STRING, (Object)uuid.toString());
                    GameProfileStorage gameProfileStorage = (GameProfileStorage)wrapper.user().get(GameProfileStorage.class);
                    GameProfileStorage.GameProfile gameProfile = gameProfileStorage.get(uuid);
                    if (gameProfile == null) {
                        wrapper.write(Types.STRING, (Object)"");
                        wrapper.write((Type)Types.VAR_INT, (Object)0);
                    } else {
                        wrapper.write(Types.STRING, (Object)(gameProfile.name.length() > 16 ? gameProfile.name.substring(0, 16) : gameProfile.name));
                        wrapper.write((Type)Types.VAR_INT, (Object)gameProfile.properties.size());
                        for (GameProfileStorage.Property property : gameProfile.properties) {
                            wrapper.write(Types.STRING, (Object)property.name);
                            wrapper.write(Types.STRING, (Object)property.value);
                            wrapper.write(Types.STRING, (Object)(property.signature == null ? "" : property.signature));
                        }
                    }
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    if (gameProfile != null && gameProfile.gamemode == 3) {
                        for (short i = 0; i < 5; i = (short)(i + 1)) {
                            PacketWrapper entityEquipment = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_EQUIPPED_ITEM, (UserConnection)wrapper.user());
                            entityEquipment.write((Type)Types.INT, (Object)entityId);
                            entityEquipment.write((Type)Types.SHORT, (Object)i);
                            entityEquipment.write(RewindTypes.COMPRESSED_NBT_ITEM, (Object)(i == 4 ? gameProfile.getSkull() : null));
                            entityEquipment.scheduleSend(Protocol1_8To1_7_6_10.class);
                        }
                    }
                    tracker.addPlayer(entityId, uuid);
                });
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.SHORT);
                this.map(Types1_8.ENTITY_DATA_LIST, Types1_7_6_10.ENTITY_DATA_LIST);
                this.handler(EntityPacketRewriter1_8.this.getTrackerAndDataHandler(Types1_7_6_10.ENTITY_DATA_LIST, (EntityType)EntityTypes1_8.EntityType.PLAYER));
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_EQUIPPED_ITEM, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.SHORT);
                this.map(Types.ITEM1_8, RewindTypes.COMPRESSED_NBT_ITEM);
                this.handler(wrapper -> ((Protocol1_8To1_7_6_10)EntityPacketRewriter1_8.this.protocol).getItemRewriter().handleItemToClient(wrapper.user(), (Item)wrapper.get(RewindTypes.COMPRESSED_NBT_ITEM, 0)));
                this.handler(wrapper -> {
                    short limit;
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    int id = (Integer)wrapper.get((Type)Types.INT, 0);
                    short s = limit = tracker.clientEntityId() == id ? (short)3 : (short)4;
                    if ((Short)wrapper.get((Type)Types.SHORT, 0) > limit) {
                        wrapper.cancel();
                    }
                });
                this.handler(wrapper -> {
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    short slot = (Short)wrapper.get((Type)Types.SHORT, 0);
                    UUID uuid = tracker.getPlayerUUID((Integer)wrapper.get((Type)Types.INT, 0));
                    if (uuid == null) {
                        return;
                    }
                    Item item = (Item)wrapper.get(RewindTypes.COMPRESSED_NBT_ITEM, 0);
                    ((PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class)).setPlayerEquipment(uuid, item, slot);
                    GameProfileStorage storage = (GameProfileStorage)wrapper.user().get(GameProfileStorage.class);
                    GameProfileStorage.GameProfile profile = storage.get(uuid);
                    if (profile != null && profile.gamemode == 3) {
                        wrapper.cancel();
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.PLAYER_SLEEP, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.U_BYTE_POSITION);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.TAKE_ITEM_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.handler(wrapper -> wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class).removeEntity(((Integer)wrapper.get((Type)Types.INT, 0)).intValue()));
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_ENTITY_MOTION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.MOVE_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.MOVE_ENTITY_POS, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.read((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    VirtualHologramEntity hologram = (VirtualHologramEntity)tracker.getHolograms().get(wrapper.get((Type)Types.INT, 0));
                    if (hologram != null) {
                        wrapper.cancel();
                        byte x = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        byte y = (Byte)wrapper.get((Type)Types.BYTE, 1);
                        byte z = (Byte)wrapper.get((Type)Types.BYTE, 2);
                        hologram.setRelativePosition((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.MOVE_ENTITY_ROT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.read((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    VirtualHologramEntity hologram = (VirtualHologramEntity)tracker.getHolograms().get(wrapper.get((Type)Types.INT, 0));
                    if (hologram != null) {
                        wrapper.cancel();
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        byte pitch = (Byte)wrapper.get((Type)Types.BYTE, 1);
                        hologram.setRotation((float)yaw * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.MOVE_ENTITY_POS_ROT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.read((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    VirtualHologramEntity hologram = (VirtualHologramEntity)tracker.getHolograms().get(wrapper.get((Type)Types.INT, 0));
                    if (hologram != null) {
                        wrapper.cancel();
                        byte x = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        byte y = (Byte)wrapper.get((Type)Types.BYTE, 1);
                        byte z = (Byte)wrapper.get((Type)Types.BYTE, 2);
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 3);
                        byte pitch = (Byte)wrapper.get((Type)Types.BYTE, 4);
                        hologram.setRelativePosition((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                        hologram.setRotation((float)yaw * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.TELEPORT_ENTITY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.read((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    VirtualHologramEntity hologram;
                    int entityId = (Integer)wrapper.get((Type)Types.INT, 0);
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    if (tracker.entityType(entityId) == EntityTypes1_8.EntityType.ABSTRACT_MINECART) {
                        int y = (Integer)wrapper.get((Type)Types.INT, 2);
                        wrapper.set((Type)Types.INT, 2, (Object)(y += 12));
                    }
                    if ((hologram = (VirtualHologramEntity)tracker.getHolograms().get(entityId)) != null) {
                        wrapper.cancel();
                        int x = (Integer)wrapper.get((Type)Types.INT, 1);
                        int y = (Integer)wrapper.get((Type)Types.INT, 2);
                        int z = (Integer)wrapper.get((Type)Types.INT, 3);
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        byte pitch = (Byte)wrapper.get((Type)Types.BYTE, 1);
                        hologram.setPosition((double)x / 32.0, (double)y / 32.0, (double)z / 32.0);
                        hologram.setRotation((float)yaw * 360.0f / 256.0f, (float)pitch * 360.0f / 256.0f);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.ROTATE_HEAD, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.handler(wrapper -> {
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    VirtualHologramEntity hologram = (VirtualHologramEntity)tracker.getHolograms().get(wrapper.get((Type)Types.INT, 0));
                    if (hologram != null) {
                        wrapper.cancel();
                        byte yaw = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        hologram.setHeadYaw((float)yaw * 360.0f / 256.0f);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_ENTITY_LINK, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map((Type)Types.INT);
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    boolean leash = (Boolean)wrapper.get((Type)Types.BOOLEAN, 0);
                    if (!leash) {
                        EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                        int passenger = (Integer)wrapper.get((Type)Types.INT, 0);
                        int vehicle = (Integer)wrapper.get((Type)Types.INT, 1);
                        tracker.setPassenger(vehicle, passenger);
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.UPDATE_MOB_EFFECT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.VAR_INT, (Type)Types.SHORT);
                this.read((Type)Types.BYTE);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.REMOVE_MOB_EFFECT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.map((Type)Types.BYTE);
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).registerClientbound((ClientboundPacketType)ClientboundPackets1_8.UPDATE_ATTRIBUTES, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT, (Type)Types.INT);
                this.handler(wrapper -> {
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    if (tracker.getHolograms().containsKey(wrapper.get((Type)Types.INT, 0))) {
                        wrapper.cancel();
                        return;
                    }
                    int amount = (Integer)wrapper.passthrough((Type)Types.INT);
                    for (int i = 0; i < amount; ++i) {
                        wrapper.passthrough(Types.STRING);
                        wrapper.passthrough((Type)Types.DOUBLE);
                        int modifierLength = (Integer)wrapper.read((Type)Types.VAR_INT);
                        wrapper.write((Type)Types.SHORT, (Object)((short)modifierLength));
                        for (int j = 0; j < modifierLength; ++j) {
                            wrapper.passthrough(Types.UUID);
                            wrapper.passthrough((Type)Types.DOUBLE);
                            wrapper.passthrough((Type)Types.BYTE);
                        }
                    }
                });
            }
        });
        ((Protocol1_8To1_7_6_10)this.protocol).cancelClientbound((ClientboundPacketType)ClientboundPackets1_8.UPDATE_ENTITY_NBT);
    }

    protected void registerRewrites() {
        this.mapEntityTypeWithData((EntityType)EntityTypes1_8.EntityType.GUARDIAN, (EntityType)EntityTypes1_8.EntityType.SQUID).plainName();
        this.mapEntityTypeWithData((EntityType)EntityTypes1_8.EntityType.ENDERMITE, (EntityType)EntityTypes1_8.EntityType.SQUID).plainName();
        this.mapEntityTypeWithData((EntityType)EntityTypes1_8.EntityType.RABBIT, (EntityType)EntityTypes1_8.EntityType.CHICKEN).plainName();
        this.filter().handler(this::handleEntityData);
    }

    public void handleEntityData(EntityDataHandlerEvent event, EntityData entityData) {
        EntityDataIndex1_7_6_10 metaIndex = EntityDataIndex1_7_6_10.searchIndex(event.entityType(), entityData.id());
        if (metaIndex == null) {
            event.cancel();
            return;
        }
        if (metaIndex.getOldType() == null) {
            event.cancel();
            return;
        }
        Object value = entityData.getValue();
        entityData.setTypeAndValue((EntityDataType)metaIndex.getNewType(), value);
        entityData.setDataTypeUnsafe((EntityDataType)metaIndex.getOldType());
        entityData.setId(metaIndex.getIndex());
        switch (metaIndex.getOldType()) {
            case INT: {
                if (metaIndex.getNewType() == EntityDataTypes1_8.BYTE) {
                    entityData.setValue((Object)((Byte)value).intValue());
                    if (metaIndex == EntityDataIndex1_7_6_10.ABSTRACT_AGEABLE_AGE && (Integer)entityData.getValue() < 0) {
                        entityData.setValue((Object)-25000);
                    }
                }
                if (metaIndex.getNewType() == EntityDataTypes1_8.SHORT) {
                    entityData.setValue((Object)((Short)value).intValue());
                }
                if (metaIndex.getNewType() != EntityDataTypes1_8.INT) break;
                entityData.setValue(value);
                break;
            }
            case BYTE: {
                if (metaIndex.getNewType() == EntityDataTypes1_8.INT) {
                    entityData.setValue((Object)((Integer)value).byteValue());
                }
                if (metaIndex.getNewType() == EntityDataTypes1_8.BYTE) {
                    if (metaIndex == EntityDataIndex1_7_6_10.ITEM_FRAME_ROTATION) {
                        entityData.setValue((Object)Integer.valueOf((Byte)value % 4).byteValue());
                    } else {
                        entityData.setValue(value);
                    }
                }
                if (metaIndex != EntityDataIndex1_7_6_10.PLAYER_SKIN_FLAGS) break;
                byte flags = (Byte)value;
                boolean cape = (flags & 1) != 0;
                flags = (byte)(cape ? 0 : 2);
                entityData.setValue((Object)flags);
                break;
            }
            case ITEM: {
                entityData.setValue((Object)((Protocol1_8To1_7_6_10)this.protocol).getItemRewriter().handleItemToClient(event.user(), (Item)value));
                break;
            }
            case FLOAT: 
            case STRING: 
            case SHORT: 
            case POSITION: {
                entityData.setValue(value);
                break;
            }
            default: {
                event.cancel();
            }
        }
    }

    public EntityTypes1_8.EntityType typeFromId(int type) {
        return EntityTypes1_8.getTypeFromId((int)type, (boolean)false);
    }

    public EntityTypes1_8.EntityType objectTypeFromId(int type) {
        return EntityTypes1_8.getTypeFromId((int)type, (boolean)true);
    }
}

