/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commandtags.paywalls.itempaywall;

import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.commandtags.PaywallEvent;
import me.rockyhawk.commandpanels.commandtags.PaywallOutput;
import me.rockyhawk.commandpanels.commandtags.paywalls.itempaywall.InventoryOperationResult;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public class ItemPaywall
implements Listener {
    CommandPanels plugin;

    public ItemPaywall(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void commandTag(PaywallEvent e) {
        if (e.name.equalsIgnoreCase("item-paywall=")) {
            try {
                ItemStack sellItem;
                boolean ignoreNBT = false;
                for (String val : e.args) {
                    if (!val.equals("IGNORENBT")) continue;
                    ignoreNBT = true;
                    break;
                }
                if (Material.matchMaterial((String)e.args[0]) == null) {
                    sellItem = this.plugin.itemCreate.makeCustomItemFromConfig(e.panel, PanelPosition.Top, e.panel.getConfig().getConfigurationSection("custom-item." + e.args[0]), e.p, true, true, false);
                    sellItem.setAmount(Integer.parseInt(e.args[1]));
                } else {
                    sellItem = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)e.args[0])), Integer.parseInt(e.args[1]));
                }
                PaywallOutput removedItem = PaywallOutput.Blocked;
                if (this.removeItem(e.p, sellItem, ignoreNBT, e.doDelete)) {
                    removedItem = PaywallOutput.Passed;
                }
                if (removedItem == PaywallOutput.Blocked) {
                    if (this.plugin.config.getBoolean("purchase.item.enable")) {
                        this.plugin.tex.sendString(e.panel, PanelPosition.Top, e.p, Objects.requireNonNull(this.plugin.config.getString("purchase.item.failure")));
                    }
                } else if (this.plugin.config.getBoolean("purchase.item.enable") && e.doDelete) {
                    this.plugin.tex.sendString(e.panel, PanelPosition.Top, e.p, Objects.requireNonNull(this.plugin.config.getString("purchase.item.success")).replaceAll("%cp-args%", e.args[0]));
                }
                e.PAYWALL_OUTPUT = removedItem;
            }
            catch (Exception buyc) {
                this.plugin.debug(buyc, e.p);
                this.plugin.tex.sendString(e.p, this.plugin.tag + this.plugin.config.getString("config.format.error") + " commands: " + e.name);
                e.PAYWALL_OUTPUT = PaywallOutput.Blocked;
            }
        }
    }

    public boolean removeItem(Player p, ItemStack itemToRemove, boolean ignoreNBT, boolean doDelete) {
        InventoryOperationResult result;
        if (this.plugin.inventorySaver.hasNormalInventory(p)) {
            result = this.removeItemFromInventory(p.getInventory().getContents(), itemToRemove, ignoreNBT, doDelete);
            p.getInventory().setContents(result.getInventory());
        } else {
            ItemStack[] savedInventory = this.plugin.inventorySaver.getNormalInventory(p);
            result = this.removeItemFromInventory(savedInventory, itemToRemove, ignoreNBT, doDelete);
            this.plugin.inventorySaver.inventoryConfig.set(p.getUniqueId().toString(), (Object)this.plugin.itemSerializer.itemStackArrayToBase64(result.getInventory()));
        }
        return result.isSuccess();
    }

    private InventoryOperationResult removeItemFromInventory(ItemStack[] inventory, ItemStack itemToRemove, boolean ignoreNBT, boolean doDelete) {
        int amountToRemove = itemToRemove.getAmount();
        int count = 0;
        for (ItemStack item : inventory) {
            if (item == null || !this.plugin.itemCreate.isIdentical(item, itemToRemove, !ignoreNBT)) continue;
            count += item.getAmount();
        }
        if (count < amountToRemove) {
            return new InventoryOperationResult(false, inventory);
        }
        if (!doDelete) {
            return new InventoryOperationResult(true, inventory);
        }
        for (int i = 0; i < inventory.length; ++i) {
            ItemStack currentItem = inventory[i];
            if (currentItem == null || !this.plugin.itemCreate.isIdentical(currentItem, itemToRemove, !ignoreNBT)) continue;
            int removeAmount = Math.min(currentItem.getAmount(), amountToRemove);
            currentItem.setAmount(currentItem.getAmount() - removeAmount);
            amountToRemove -= removeAmount;
            if (currentItem.getAmount() == 0) {
                inventory[i] = null;
            }
            if (amountToRemove == 0) break;
        }
        return new InventoryOperationResult(true, inventory);
    }
}

