/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileUtil {
    @Nullable
    public static <T> Class<? extends T> findClass(@NotNull File file, @NotNull Class<T> clazz) throws IOException, ClassNotFoundException {
        if (!file.exists()) {
            return null;
        }
        URL jar = file.toURI().toURL();
        URLClassLoader loader = new URLClassLoader(new URL[]{jar}, clazz.getClassLoader());
        ArrayList<String> matches = new ArrayList<String>();
        ArrayList<Class<T>> classes = new ArrayList<Class<T>>();
        try (JarInputStream stream = new JarInputStream(jar.openStream());){
            JarEntry entry;
            while ((entry = stream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name.isEmpty() || !name.endsWith(".class")) continue;
                matches.add(name.substring(0, name.lastIndexOf(46)).replace('/', '.'));
            }
            for (String match : matches) {
                try {
                    Class<?> loaded = loader.loadClass(match);
                    if (!clazz.isAssignableFrom(loaded)) continue;
                    classes.add(loaded.asSubclass(clazz));
                }
                catch (NoClassDefFoundError noClassDefFoundError) {}
            }
        }
        if (classes.isEmpty()) {
            loader.close();
            return null;
        }
        return (Class)classes.get(0);
    }
}

