/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_9to1_8.rewriter;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.viarewind.ViaRewind;
import com.viaversion.viarewind.protocol.v1_9to1_8.Protocol1_9To1_8;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.BlockPlaceDestroyTracker;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.BossBarStorage;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.CooldownStorage;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.EntityTracker1_9;
import com.viaversion.viarewind.protocol.v1_9to1_8.storage.PlayerPositionTracker;
import com.viaversion.viarewind.utils.ChatUtil;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_9;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityData;
import com.viaversion.viaversion.api.minecraft.entitydata.EntityDataType;
import com.viaversion.viaversion.api.minecraft.entitydata.types.EntityDataTypes1_8;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.version.Types1_8;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_9;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ServerboundPackets1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ServerboundPackets1_9;
import java.util.ArrayList;
import java.util.UUID;

public class PlayerPacketRewriter1_9 {
    public static void register(final Protocol1_9To1_8 protocol) {
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_9.BOSS_EVENT, null, wrapper -> {
            wrapper.cancel();
            BossBarStorage bossbar = (BossBarStorage)wrapper.user().get(BossBarStorage.class);
            UUID uuid = (UUID)wrapper.read(Types.UUID);
            int action = (Integer)wrapper.read((Type)Types.VAR_INT);
            if (action == 0) {
                JsonElement title = (JsonElement)wrapper.read(Types.COMPONENT);
                float health = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
                wrapper.read((Type)Types.VAR_INT);
                wrapper.read((Type)Types.VAR_INT);
                wrapper.read((Type)Types.UNSIGNED_BYTE);
                bossbar.add(uuid, ChatUtil.jsonToLegacy(wrapper.user(), title), health);
            } else if (action == 1) {
                bossbar.remove(uuid);
            } else if (action == 2) {
                float health = ((Float)wrapper.read((Type)Types.FLOAT)).floatValue();
                bossbar.updateHealth(uuid, health);
            } else if (action == 3) {
                JsonElement title = (JsonElement)wrapper.read(Types.COMPONENT);
                bossbar.updateTitle(uuid, ChatUtil.jsonToLegacy(wrapper.user(), title));
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_9.SET_PLAYER_TEAM, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.map((Type)Types.BYTE);
                this.handler(wrapper -> {
                    byte mode = (Byte)wrapper.get((Type)Types.BYTE, 0);
                    if (mode == 0 || mode == 2) {
                        wrapper.passthrough(Types.STRING);
                        wrapper.passthrough(Types.STRING);
                        wrapper.passthrough(Types.STRING);
                        wrapper.passthrough((Type)Types.BYTE);
                        wrapper.passthrough(Types.STRING);
                        wrapper.read(Types.STRING);
                    }
                });
            }
        });
        protocol.cancelClientbound((ClientboundPacketType)ClientboundPackets1_9.COOLDOWN);
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_9.CUSTOM_PAYLOAD, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.handlerSoftFail(wrapper -> {
                    String channel = (String)wrapper.get(Types.STRING, 0);
                    if (channel.equals("MC|BOpen")) {
                        wrapper.read((Type)Types.VAR_INT);
                    } else if (channel.equals("MC|TrList")) {
                        protocol.getItemRewriter().handleTradeList(wrapper);
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_9.PLAYER_POSITION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.BYTE);
                this.handler(wrapper -> {
                    PlayerPositionTracker pos = (PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class);
                    pos.setConfirmId((Integer)wrapper.read((Type)Types.VAR_INT));
                    byte flags = (Byte)wrapper.get((Type)Types.BYTE, 0);
                    double x = (Double)wrapper.get((Type)Types.DOUBLE, 0);
                    double y = (Double)wrapper.get((Type)Types.DOUBLE, 1);
                    double z = (Double)wrapper.get((Type)Types.DOUBLE, 2);
                    float yaw = ((Float)wrapper.get((Type)Types.FLOAT, 0)).floatValue();
                    float pitch = ((Float)wrapper.get((Type)Types.FLOAT, 1)).floatValue();
                    wrapper.set((Type)Types.BYTE, 0, (Object)0);
                    if (flags != 0) {
                        if ((flags & 1) != 0) {
                            wrapper.set((Type)Types.DOUBLE, 0, (Object)(x += pos.getPosX()));
                        }
                        if ((flags & 2) != 0) {
                            wrapper.set((Type)Types.DOUBLE, 1, (Object)(y += pos.getPosY()));
                        }
                        if ((flags & 4) != 0) {
                            wrapper.set((Type)Types.DOUBLE, 2, (Object)(z += pos.getPosZ()));
                        }
                        if ((flags & 8) != 0) {
                            wrapper.set((Type)Types.FLOAT, 0, (Object)Float.valueOf(yaw += pos.getYaw()));
                        }
                        if ((flags & 0x10) != 0) {
                            wrapper.set((Type)Types.FLOAT, 1, (Object)Float.valueOf(pitch += pos.getPitch()));
                        }
                    }
                    pos.setPos(x, y, z);
                    pos.setYaw(yaw);
                    pos.setPitch(pitch);
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_9.RESPAWN, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.handler(wrapper -> ((BossBarStorage)wrapper.user().get(BossBarStorage.class)).reset());
                this.handler(wrapper -> {
                    ClientWorld world = (ClientWorld)wrapper.user().get(ClientWorld.class);
                    world.setEnvironment(((Integer)wrapper.get((Type)Types.INT, 0)).intValue());
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_9.PLAYER_COMBAT, wrapper -> {
            int action = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            if (action != 2) {
                return;
            }
            EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
            int entityId = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            wrapper.passthrough((Type)Types.INT);
            if (entityId != tracker.clientEntityId()) {
                return;
            }
            JsonElement message = (JsonElement)wrapper.passthrough(Types.COMPONENT);
            PacketWrapper killPlayer = wrapper.create((PacketType)ClientboundPackets1_8.SET_HEALTH);
            killPlayer.write((Type)Types.FLOAT, (Object)Float.valueOf(0.0f));
            killPlayer.write((Type)Types.VAR_INT, (Object)0);
            killPlayer.write((Type)Types.FLOAT, (Object)Float.valueOf(0.0f));
            killPlayer.scheduleSend(Protocol1_9To1_8.class);
            PacketWrapper chatMessage = wrapper.create((PacketType)ClientboundPackets1_8.CHAT);
            chatMessage.write(Types.COMPONENT, (Object)message);
            chatMessage.write((Type)Types.BYTE, (Object)1);
            chatMessage.scheduleSend(Protocol1_9To1_8.class);
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.CHAT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.handler(wrapper -> {
                    if (!ViaRewind.getConfig().isEnableOffhand()) {
                        return;
                    }
                    String message = (String)wrapper.get(Types.STRING, 0);
                    if (message.toLowerCase().trim().startsWith(ViaRewind.getConfig().getOffhandCommand())) {
                        wrapper.cancel();
                        PacketWrapper swapItems = PacketWrapper.create((PacketType)ServerboundPackets1_9.PLAYER_ACTION, (UserConnection)wrapper.user());
                        swapItems.write((Type)Types.VAR_INT, (Object)6);
                        swapItems.write(Types.BLOCK_POSITION1_8, (Object)new BlockPosition(0, 0, 0));
                        swapItems.write((Type)Types.UNSIGNED_BYTE, (Object)255);
                        swapItems.sendToServer(Protocol1_9To1_8.class);
                    }
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.INTERACT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.VAR_INT);
                this.handler(wrapper -> {
                    int type = (Integer)wrapper.get((Type)Types.VAR_INT, 1);
                    if (type == 2) {
                        wrapper.passthrough((Type)Types.FLOAT);
                        wrapper.passthrough((Type)Types.FLOAT);
                        wrapper.passthrough((Type)Types.FLOAT);
                    }
                    if (type == 2 || type == 0) {
                        wrapper.write((Type)Types.VAR_INT, (Object)0);
                    }
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.MOVE_PLAYER_STATUS_ONLY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    ((PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class)).sendAnimations();
                    EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
                    if (tracker.isInsideVehicle(tracker.clientEntityId())) {
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.MOVE_PLAYER_POS, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    ((PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class)).sendAnimations();
                    PlayerPositionTracker pos = (PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class);
                    if (pos.getConfirmId() != -1) {
                        return;
                    }
                    pos.setPos((Double)wrapper.get((Type)Types.DOUBLE, 0), (Double)wrapper.get((Type)Types.DOUBLE, 1), (Double)wrapper.get((Type)Types.DOUBLE, 2));
                    pos.setOnGround((Boolean)wrapper.get((Type)Types.BOOLEAN, 0));
                });
                this.handler(wrapper -> ((BossBarStorage)wrapper.user().get(BossBarStorage.class)).updateLocation());
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.MOVE_PLAYER_ROT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    ((PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class)).sendAnimations();
                    PlayerPositionTracker pos = (PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class);
                    if (pos.getConfirmId() != -1) {
                        return;
                    }
                    pos.setYaw(((Float)wrapper.get((Type)Types.FLOAT, 0)).floatValue());
                    pos.setPitch(((Float)wrapper.get((Type)Types.FLOAT, 1)).floatValue());
                    pos.setOnGround((Boolean)wrapper.get((Type)Types.BOOLEAN, 0));
                });
                this.handler(wrapper -> ((BossBarStorage)wrapper.user().get(BossBarStorage.class)).updateLocation());
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.MOVE_PLAYER_POS_ROT, wrapper -> {
            double x = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            double y = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            double z = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            float yaw = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            float pitch = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            boolean onGround = (Boolean)wrapper.passthrough((Type)Types.BOOLEAN);
            PlayerPositionTracker storage = (PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class);
            storage.sendAnimations();
            if (storage.getConfirmId() != -1) {
                if (storage.getPosX() == x && storage.getPosY() == y && storage.getPosZ() == z && storage.getYaw() == yaw && storage.getPitch() == pitch) {
                    PacketWrapper confirmTeleport = PacketWrapper.create((PacketType)ServerboundPackets1_9.ACCEPT_TELEPORTATION, (UserConnection)wrapper.user());
                    confirmTeleport.write((Type)Types.VAR_INT, (Object)storage.getConfirmId());
                    confirmTeleport.sendToServer(Protocol1_9To1_8.class);
                    storage.setConfirmId(-1);
                }
            } else {
                storage.setPos(x, y, z);
                storage.setYaw(yaw);
                storage.setPitch(pitch);
                storage.setOnGround(onGround);
                ((BossBarStorage)wrapper.user().get(BossBarStorage.class)).updateLocation();
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.PLAYER_ACTION, wrapper -> {
            int status = (Integer)wrapper.passthrough((Type)Types.VAR_INT);
            BlockPlaceDestroyTracker tracker = (BlockPlaceDestroyTracker)wrapper.user().get(BlockPlaceDestroyTracker.class);
            if (status == 0 || status == 1 || status == 2) {
                tracker.setMining();
            }
            CooldownStorage cooldown = (CooldownStorage)wrapper.user().get(CooldownStorage.class);
            if (status == 1) {
                tracker.setLastMining(0L);
                cooldown.hit();
            } else if (status == 2) {
                tracker.setLastMining(System.currentTimeMillis() + 100L);
                cooldown.setLastHit(0L);
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.USE_ITEM_ON, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8);
                this.map((Type)Types.BYTE, (Type)Types.VAR_INT);
                this.read(Types.ITEM1_8);
                this.create((Type)Types.VAR_INT, 0);
                this.map((Type)Types.BYTE, (Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.BYTE, (Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.BYTE, (Type)Types.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    if ((Integer)wrapper.get((Type)Types.VAR_INT, 0) == -1) {
                        wrapper.cancel();
                        PacketWrapper useItem = PacketWrapper.create((PacketType)ServerboundPackets1_9.USE_ITEM, (UserConnection)wrapper.user());
                        useItem.write((Type)Types.VAR_INT, (Object)0);
                        useItem.sendToServer(Protocol1_9To1_8.class);
                    }
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.SET_CARRIED_ITEM, wrapper -> ((CooldownStorage)wrapper.user().get(CooldownStorage.class)).hit());
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.SWING, wrapper -> {
            wrapper.cancel();
            PacketWrapper swing = PacketWrapper.create((PacketType)ServerboundPackets1_9.SWING, (UserConnection)wrapper.user());
            swing.write((Type)Types.VAR_INT, (Object)0);
            ((PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class)).queueAnimation(swing);
            ((BlockPlaceDestroyTracker)wrapper.user().get(BlockPlaceDestroyTracker.class)).updateMining();
            ((CooldownStorage)wrapper.user().get(CooldownStorage.class)).hit();
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.PLAYER_COMMAND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.VAR_INT);
                this.map((Type)Types.VAR_INT);
                this.handler(wrapper -> {
                    PlayerPositionTracker tracker = (PlayerPositionTracker)wrapper.user().get(PlayerPositionTracker.class);
                    int action = (Integer)wrapper.get((Type)Types.VAR_INT, 1);
                    if (action == 6) {
                        wrapper.set((Type)Types.VAR_INT, 1, (Object)7);
                    } else if (action == 0 && !tracker.isOnGround()) {
                        PacketWrapper elytra = PacketWrapper.create((PacketType)ServerboundPackets1_9.PLAYER_COMMAND, (UserConnection)wrapper.user());
                        elytra.write((Type)Types.VAR_INT, (Object)((Integer)wrapper.get((Type)Types.VAR_INT, 0)));
                        elytra.write((Type)Types.VAR_INT, (Object)8);
                        elytra.write((Type)Types.VAR_INT, (Object)0);
                        elytra.scheduleSendToServer(Protocol1_9To1_8.class);
                    }
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.PLAYER_INPUT, wrapper -> {
            float sideways = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            float forward = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            EntityTracker1_9 tracker = (EntityTracker1_9)wrapper.user().getEntityTracker(Protocol1_9To1_8.class);
            int vehicle = tracker.getVehicle(tracker.clientEntityId());
            if (vehicle != -1 && tracker.entityType(vehicle) == EntityTypes1_9.EntityType.BOAT) {
                PacketWrapper paddleBoat = PacketWrapper.create((PacketType)ServerboundPackets1_9.PADDLE_BOAT, (UserConnection)wrapper.user());
                paddleBoat.write((Type)Types.BOOLEAN, (Object)(forward != 0.0f || sideways < 0.0f ? 1 : 0));
                paddleBoat.write((Type)Types.BOOLEAN, (Object)(forward != 0.0f || sideways > 0.0f ? 1 : 0));
                paddleBoat.scheduleSendToServer(Protocol1_9To1_8.class);
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.SIGN_UPDATE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8);
                this.handler(wrapper -> {
                    for (int i = 0; i < 4; ++i) {
                        wrapper.write(Types.STRING, (Object)ChatUtil.jsonToLegacy(wrapper.user(), (JsonElement)wrapper.read(Types.COMPONENT)));
                    }
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.COMMAND_SUGGESTION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.create((Type)Types.BOOLEAN, false);
                this.map(Types.OPTIONAL_POSITION1_8);
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.CLIENT_INFORMATION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE, (Type)Types.VAR_INT);
                this.map((Type)Types.BOOLEAN);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.create((Type)Types.VAR_INT, 1);
                this.handler(wrapper -> {
                    short flags = (Short)wrapper.get((Type)Types.UNSIGNED_BYTE, 0);
                    PacketWrapper updateSkin = PacketWrapper.create((PacketType)ClientboundPackets1_8.SET_ENTITY_DATA, (UserConnection)wrapper.user());
                    updateSkin.write((Type)Types.VAR_INT, (Object)wrapper.user().getEntityTracker(Protocol1_9To1_8.class).clientEntityId());
                    ArrayList<EntityData> entityData = new ArrayList<EntityData>();
                    entityData.add(new EntityData(10, (EntityDataType)EntityDataTypes1_8.BYTE, (Object)((byte)flags)));
                    updateSkin.write(Types1_8.ENTITY_DATA_LIST, entityData);
                    updateSkin.scheduleSend(Protocol1_9To1_8.class);
                });
            }
        });
        protocol.registerServerbound((ServerboundPacketType)ServerboundPackets1_8.CUSTOM_PAYLOAD, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.handlerSoftFail(wrapper -> {
                    String channel = (String)wrapper.get(Types.STRING, 0);
                    if (channel.equals("MC|BEdit") || channel.equals("MC|BSign")) {
                        Item book = (Item)wrapper.passthrough(Types.ITEM1_8);
                        book.setIdentifier(386);
                        CompoundTag tag = book.tag();
                        if (tag.contains("pages")) {
                            ListTag pages = tag.getListTag("pages", StringTag.class);
                            if (pages.size() > ViaRewind.getConfig().getMaxBookPages()) {
                                wrapper.user().disconnect("Too many book pages");
                                return;
                            }
                            for (int i = 0; i < pages.size(); ++i) {
                                StringTag page = (StringTag)pages.get(i);
                                String value = page.getValue();
                                if (value.length() > ViaRewind.getConfig().getMaxBookPageSize()) {
                                    wrapper.user().disconnect("Book page too large");
                                    return;
                                }
                                value = ChatUtil.jsonToLegacy(wrapper.user(), value);
                                page.setValue(value);
                            }
                        }
                    } else if (channel.equals("MC|AdvCdm")) {
                        wrapper.set(Types.STRING, 0, (Object)"MC|AdvCmd");
                    }
                });
            }
        });
    }
}

