/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.commandtags;

import java.util.ArrayList;
import java.util.List;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.commandtags.CommandTagEvent;
import me.rockyhawk.commandpanels.commandtags.PaywallEvent;
import me.rockyhawk.commandpanels.commandtags.PaywallOutput;
import me.rockyhawk.commandpanels.commandtags.paywalls.DataPaywall;
import me.rockyhawk.commandpanels.commandtags.paywalls.Hasperm;
import me.rockyhawk.commandpanels.commandtags.paywalls.Paywall;
import me.rockyhawk.commandpanels.commandtags.paywalls.TokenPaywall;
import me.rockyhawk.commandpanels.commandtags.paywalls.XpPaywall;
import me.rockyhawk.commandpanels.commandtags.paywalls.itempaywall.ItemPaywall;
import me.rockyhawk.commandpanels.commandtags.tags.other.DataTags;
import me.rockyhawk.commandpanels.commandtags.tags.other.PlaceholderTags;
import me.rockyhawk.commandpanels.commandtags.tags.other.SpecialTags;
import me.rockyhawk.commandpanels.commandtags.tags.standard.BasicTags;
import me.rockyhawk.commandpanels.commandtags.tags.standard.BungeeTags;
import me.rockyhawk.commandpanels.commandtags.tags.standard.ItemTags;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.plugin.Plugin;

public class CommandRunner {
    CommandPanels plugin;

    public CommandRunner(CommandPanels pl) {
        this.plugin = pl;
    }

    public void runCommands(Panel panel, PanelPosition position, Player p, List<String> commands, ClickType click) {
        for (String command : commands) {
            if (click != null && (command = this.plugin.commandRunner.hasCorrectClick(command, click)).equals("")) continue;
            PaywallEvent paywallEvent = new PaywallEvent(this.plugin, panel, position, p, command);
            Bukkit.getPluginManager().callEvent((Event)paywallEvent);
            if (paywallEvent.PAYWALL_OUTPUT == PaywallOutput.Blocked) break;
            if (paywallEvent.PAYWALL_OUTPUT != PaywallOutput.NotApplicable) continue;
            this.plugin.commandRunner.runCommand(panel, position, p, command);
        }
    }

    public void runCommand(Panel panel, PanelPosition position, Player p, String commandRAW) {
        CommandTagEvent tags = new CommandTagEvent(this.plugin, panel, position, p, commandRAW);
        Bukkit.getPluginManager().callEvent((Event)tags);
        if (!tags.commandTagUsed) {
            Bukkit.dispatchCommand((CommandSender)p, (String)this.plugin.tex.attachPlaceholders(panel, position, p, commandRAW.trim()));
        }
    }

    public boolean runMultiPaywall(Panel panel, PanelPosition position, Player p, List<String> paywalls, List<String> commands, ClickType click) {
        boolean allPaywallsValid = true;
        ArrayList<String> allCommands = new ArrayList<String>(paywalls);
        allCommands.addAll(commands);
        for (String command : allCommands) {
            PaywallEvent paywallEvent = new PaywallEvent(this.plugin, panel, position, p, command);
            paywallEvent.doDelete = false;
            Bukkit.getPluginManager().callEvent((Event)paywallEvent);
            if (paywallEvent.PAYWALL_OUTPUT != PaywallOutput.Blocked) continue;
            allPaywallsValid = false;
            break;
        }
        if (allPaywallsValid) {
            this.plugin.commandRunner.runCommands(panel, position, p, allCommands, click);
        }
        return allPaywallsValid;
    }

    public void registerBuiltInTags() {
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new Paywall(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new TokenPaywall(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new ItemPaywall(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new Hasperm(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new XpPaywall(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new DataPaywall(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new DataTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new PlaceholderTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new SpecialTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new BasicTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new BungeeTags(this.plugin), (Plugin)this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)new ItemTags(this.plugin), (Plugin)this.plugin);
    }

    public String hasCorrectClick(String command, ClickType click) {
        try {
            switch (command.split("\\s")[0]) {
                case "right=": {
                    command = command.replace("right= ", "");
                    if (click == ClickType.RIGHT) break;
                    return "";
                }
                case "rightshift=": {
                    command = command.replace("rightshift= ", "");
                    if (click == ClickType.SHIFT_RIGHT) break;
                    return "";
                }
                case "left=": {
                    command = command.replace("left= ", "");
                    if (click == ClickType.LEFT) break;
                    return "";
                }
                case "leftshift=": {
                    command = command.replace("leftshift= ", "");
                    if (click == ClickType.SHIFT_LEFT) break;
                    return "";
                }
                case "middle=": {
                    command = command.replace("middle= ", "");
                    if (click == ClickType.MIDDLE) break;
                    return "";
                }
            }
            return command;
        }
        catch (Exception ex) {
            return "";
        }
    }
}

