/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.papi.expansion.player;

import com.extendedclip.papi.expansion.player.VersionHelper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.function.Function;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;

public final class PlayerUtil {
    public static final int ticksAtMidnight = 18000;
    public static final int ticksPerDay = 24000;
    public static final int ticksPerHour = 1000;
    public static final double ticksPerMinute = 16.666666666666668;
    private static final SimpleDateFormat twentyFour = new SimpleDateFormat("HH:mm", Locale.ENGLISH);
    private static final SimpleDateFormat twelve = new SimpleDateFormat("h:mm aa", Locale.ENGLISH);
    private static final BlockFace[] radial = new BlockFace[]{BlockFace.NORTH, BlockFace.NORTH_EAST, BlockFace.EAST, BlockFace.SOUTH_EAST, BlockFace.SOUTH, BlockFace.SOUTH_WEST, BlockFace.WEST, BlockFace.NORTH_WEST};
    private static final Function<Player, Integer> PLAYER_GET_PING = new Function<Player, Integer>(){
        private Field ping;
        private Method getHandle;

        @Override
        public Integer apply(Player player) {
            if (VersionHelper.IS_1_17_OR_NEWER) {
                return player.getPing();
            }
            if (this.ping == null) {
                try {
                    this.cacheReflection(player);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                return this.ping.getInt(this.getHandle.invoke((Object)player, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                PlaceholderAPIPlugin.getInstance().getLogger().log(Level.SEVERE, "Could not get the ping of " + player.getName() + ", using -1 as fallback value", ex);
                return -1;
            }
        }

        private void cacheReflection(Player player) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            this.getHandle = player.getClass().getDeclaredMethod("getHandle", new Class[0]);
            this.getHandle.setAccessible(true);
            Object entityPlayer = this.getHandle.invoke((Object)player, new Object[0]);
            this.ping = entityPlayer.getClass().getDeclaredField("ping");
            this.ping.setAccessible(true);
        }
    };
    private static final Function<Player, String> PLAYER_GET_LOCALE = new Function<Player, String>(){
        private Field locale;
        private Method getHandle;

        @Override
        public String apply(Player player) {
            if (this.locale == null) {
                try {
                    this.cacheReflection(player);
                }
                catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException ex) {
                    ex.printStackTrace();
                }
            }
            try {
                Object entityPlayer = this.getHandle.invoke((Object)player, new Object[0]);
                return (String)this.locale.get(entityPlayer);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                PlaceholderAPIPlugin.getInstance().getLogger().log(Level.SEVERE, "Could not get the locale of " + player.getName() + ", using 'en_US' as fallback value", ex);
                return "en_US";
            }
        }

        private void cacheReflection(Player player) throws NoSuchFieldException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
            this.getHandle = player.getClass().getDeclaredMethod("getHandle", new Class[0]);
            this.getHandle.setAccessible(true);
            Object entityPlayer = this.getHandle.invoke((Object)player, new Object[0]);
            this.locale = VersionHelper.IS_1_20_4_OR_NEWER ? entityPlayer.getClass().getField("cO") : (VersionHelper.IS_1_20_2_OR_NEWER ? entityPlayer.getClass().getField("cM") : entityPlayer.getClass().getField("locale"));
        }
    };

    private PlayerUtil() {
    }

    public static int getPing(Player player) {
        return PLAYER_GET_PING.apply(player);
    }

    public static String getLocale(Player player) {
        return PLAYER_GET_LOCALE.apply(player);
    }

    public static String format12(long ticks) {
        try {
            return twelve.format(twentyFour.parse(PlayerUtil.ticksToTime(ticks)));
        }
        catch (ParseException e) {
            return PlayerUtil.ticksToTime(ticks);
        }
    }

    public static String format24(long ticks) {
        return PlayerUtil.ticksToTime(ticks);
    }

    private static String ticksToTime(long ticks) {
        ticks = ticks - 18000L + 24000L;
        long hours = ticks / 1000L;
        long mins = (long)Math.floor((double)(ticks -= hours * 1000L) / 16.666666666666668);
        if (hours >= 24L) {
            hours -= 24L;
        }
        return (hours < 10L ? "0" + hours : Long.valueOf(hours)) + ":" + (mins < 10L ? "0" + mins : Long.valueOf(mins));
    }

    public static BlockFace getDirection(Player player) {
        return radial[Math.round(player.getLocation().getYaw() / 45.0f) & 7].getOppositeFace();
    }

    public static String getXZDirection(Player player) {
        double rotation = player.getLocation().getYaw();
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if (Math.abs(rotation) <= 45.0 || Math.abs(rotation - 360.0) <= 45.0) {
            return "+Z";
        }
        if (Math.abs(rotation - 90.0) <= 45.0) {
            return "-X";
        }
        if (Math.abs(rotation - 180.0) <= 45.0) {
            return "-Z";
        }
        if (Math.abs(rotation - 270.0) <= 45.0) {
            return "+X";
        }
        return "";
    }

    public static ItemStack itemInHand(Player p) {
        try {
            return p.getInventory().getItemInMainHand();
        }
        catch (NoSuchMethodError e) {
            return p.getInventory().getItemInHand();
        }
    }

    public static int durability(ItemStack item) {
        return item != null ? item.getType().getMaxDurability() - item.getDurability() : 0;
    }

    public static int getEmptySlots(Player p) {
        int slots = 0;
        PlayerInventory inv = p.getInventory();
        for (ItemStack is : inv.getContents()) {
            if (is != null) continue;
            ++slots;
        }
        if (!Bukkit.getBukkitVersion().contains("1.7") && !Bukkit.getBukkitVersion().contains("1.8")) {
            if (inv.getItemInOffHand() == null || inv.getItemInOffHand().getType() == Material.AIR) {
                --slots;
            }
            if (inv.getHelmet() == null) {
                --slots;
            }
            if (inv.getChestplate() == null) {
                --slots;
            }
            if (inv.getLeggings() == null) {
                --slots;
            }
            if (inv.getBoots() == null) {
                --slots;
            }
        }
        return slots;
    }

    private static int getExperienceAtLevel(int level) {
        if (level <= 15) {
            return (level << 1) + 7;
        }
        if (level <= 30) {
            return level * 5 - 38;
        }
        return level * 9 - 158;
    }

    public static int getTotalExperience(Player player) {
        int experience = Math.round((float)PlayerUtil.getExperienceAtLevel(player.getLevel()) * player.getExp());
        int currentLevel = player.getLevel();
        while (currentLevel > 0) {
            experience += PlayerUtil.getExperienceAtLevel(--currentLevel);
        }
        if (experience < 0) {
            experience = 0;
        }
        return experience;
    }

    public static String getBiome(Player p) {
        return String.valueOf(p.getLocation().getBlock().getBiome());
    }

    public static String getCapitalizedBiome(Player p) {
        CharSequence[] biomeWords = PlayerUtil.getBiome(p).split("_");
        for (int i = 0; i < biomeWords.length; ++i) {
            biomeWords[i] = ((String)biomeWords[i]).substring(0, 1).toUpperCase() + ((String)biomeWords[i]).substring(1).toLowerCase();
        }
        return String.join((CharSequence)" ", biomeWords);
    }
}

