/*
 * Decompiled with CFR 0.152.
 */
package me.wikmor.lpc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.PlaceholderAPI;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.cacheddata.CachedMetaData;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class LPC
extends JavaPlugin
implements Listener {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private LuckPerms luckPerms;

    public void onEnable() {
        this.luckPerms = (LuckPerms)this.getServer().getServicesManager().load(LuckPerms.class);
        this.saveDefaultConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && "reload".equals(args[0])) {
            this.reloadConfig();
            sender.sendMessage(this.colorize("&aLPC has been reloaded."));
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        if (args.length == 1) {
            return Collections.singletonList("reload");
        }
        return new ArrayList<String>();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChat(AsyncPlayerChatEvent event) {
        String message = event.getMessage();
        Player player = event.getPlayer();
        CachedMetaData metaData = this.luckPerms.getPlayerAdapter(Player.class).getMetaData((Object)player);
        String group = metaData.getPrimaryGroup();
        String format = this.getConfig().getString(this.getConfig().getString("group-formats." + group) != null ? "group-formats." + group : "chat-format").replace("{prefix}", metaData.getPrefix() != null ? metaData.getPrefix() : "").replace("{suffix}", metaData.getSuffix() != null ? metaData.getSuffix() : "").replace("{prefixes}", metaData.getPrefixes().keySet().stream().map(key -> (String)metaData.getPrefixes().get(key)).collect(Collectors.joining())).replace("{suffixes}", metaData.getSuffixes().keySet().stream().map(key -> (String)metaData.getSuffixes().get(key)).collect(Collectors.joining())).replace("{world}", player.getWorld().getName()).replace("{name}", player.getName()).replace("{displayname}", player.getDisplayName()).replace("{username-color}", metaData.getMetaValue("username-color") != null ? metaData.getMetaValue("username-color") : "").replace("{message-color}", metaData.getMetaValue("message-color") != null ? metaData.getMetaValue("message-color") : "");
        format = this.colorize(this.translateHexColorCodes(this.getServer().getPluginManager().isPluginEnabled("PlaceholderAPI") ? PlaceholderAPI.setPlaceholders((Player)player, (String)format) : format));
        event.setFormat(format.replace("{message}", player.hasPermission("lpc.colorcodes") && player.hasPermission("lpc.rgbcodes") ? this.colorize(this.translateHexColorCodes(message)) : (player.hasPermission("lpc.colorcodes") ? this.colorize(message) : (player.hasPermission("lpc.rgbcodes") ? this.translateHexColorCodes(message) : message))).replace("%", "%%"));
    }

    private String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String translateHexColorCodes(String message) {
        int colorChar = 167;
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer(message.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(buffer, "\u00a7x\u00a7" + group.charAt(0) + '\u00a7' + group.charAt(1) + '\u00a7' + group.charAt(2) + '\u00a7' + group.charAt(3) + '\u00a7' + group.charAt(4) + '\u00a7' + group.charAt(5));
        }
        return matcher.appendTail(buffer).toString();
    }
}

