/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.nbtapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import me.rockyhawk.commandpanels.nbtapi.NBTCompound;
import me.rockyhawk.commandpanels.nbtapi.NBTContainer;
import me.rockyhawk.commandpanels.nbtapi.NBTList;
import me.rockyhawk.commandpanels.nbtapi.NBTType;
import me.rockyhawk.commandpanels.nbtapi.NbtApiException;
import me.rockyhawk.commandpanels.nbtapi.utils.UUIDUtil;
import me.rockyhawk.commandpanels.nbtapi.utils.nmsmappings.ClassWrapper;
import me.rockyhawk.commandpanels.nbtapi.utils.nmsmappings.ReflectionMethod;

public class NBTUUIDList
extends NBTList<UUID> {
    private final NBTContainer tmpContainer = new NBTContainer();

    protected NBTUUIDList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    protected Object asTag(UUID object) {
        try {
            Constructor<?> con = ClassWrapper.NMS_NBTTAGINTARRAY.getClazz().getDeclaredConstructor(int[].class);
            con.setAccessible(true);
            return con.newInstance(new Object[]{UUIDUtil.uuidToIntArray(object)});
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }

    @Override
    public UUID get(int index) {
        try {
            Object obj = ReflectionMethod.LIST_GET.run(this.listObject, index);
            ReflectionMethod.COMPOUND_SET.run(this.tmpContainer.getCompound(), "tmp", obj);
            int[] val = this.tmpContainer.getIntArray("tmp");
            this.tmpContainer.removeKey("tmp");
            return UUIDUtil.uuidFromIntArray(val);
        }
        catch (NumberFormatException nf) {
            return null;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }
}

