/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.classresources;

import dev.lone.itemsadder.api.CustomStack;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import net.Indyuce.mmoitems.MMOItems;
import net.Indyuce.mmoitems.api.item.mmoitem.MMOItem;
import net.Indyuce.mmoitems.manager.ItemManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.enchantments.EnchantmentTarget;
import org.bukkit.enchantments.EnchantmentWrapper;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ArmorMeta;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.BookMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.inventory.meta.trim.ArmorTrim;
import org.bukkit.inventory.meta.trim.TrimMaterial;
import org.bukkit.inventory.meta.trim.TrimPattern;
import org.bukkit.potion.PotionType;

public class ItemCreation {
    CommandPanels plugin;

    public ItemCreation(CommandPanels pl) {
        this.plugin = pl;
    }

    public ItemStack makeItemFromConfig(Panel panel, PanelPosition position, ConfigurationSection itemSection, Player p, boolean placeholders, boolean colours, boolean addNBT) {
        String material = this.plugin.tex.placeholdersNoColour(panel, position, p, itemSection.getString("material"));
        try {
            if (Objects.requireNonNull(material).equalsIgnoreCase("AIR")) {
                return null;
            }
        }
        catch (NullPointerException e) {
            this.plugin.debug(e, p);
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " material: could not load material!"));
            return null;
        }
        ItemStack s = null;
        boolean hideAttributes = false;
        if (material.contains("%cp-player-online-")) {
            int start = material.indexOf("%cp-player-online-");
            int end = material.lastIndexOf("-find%");
            String playerLocation = material.substring(start, end).replace("%cp-player-online-", "");
            Player[] playerFind = Bukkit.getOnlinePlayers().toArray(new Player[Bukkit.getOnlinePlayers().size()]);
            material = Integer.parseInt(playerLocation) > playerFind.length ? material.replace(material.substring(start, end) + "-find%", "cps= " + this.plugin.config.getString("config.format.offlineHeadValue")) : material.replace(material.substring(start, end) + "-find%", "cpo= " + playerFind[Integer.parseInt(playerLocation) - 1].getName());
        }
        try {
            String trim;
            String[] trimList;
            String namespaceID;
            CustomStack stack;
            String mat = material.toUpperCase();
            String matraw = material;
            boolean normalCreation = true;
            String skullname = "no skull";
            short id = 0;
            if (itemSection.contains("ID")) {
                id = Short.parseShort(itemSection.getString("ID"));
            }
            if (matraw.split("\\s")[0].equalsIgnoreCase("cps=") || matraw.split("\\s")[0].toLowerCase().equals("cpo=")) {
                skullname = p.getUniqueId().toString();
                mat = this.plugin.getHeads.playerHeadString();
                if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                    id = 3;
                }
            }
            if (matraw.split("\\s")[0].equalsIgnoreCase("hdb=")) {
                skullname = "hdb";
                mat = this.plugin.getHeads.playerHeadString();
                if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                    id = 3;
                }
            }
            if (matraw.split("\\s")[0].equalsIgnoreCase("oraxen=")) {
                String itemID = matraw.split("\\s")[1];
                try {
                    Class<?> oraxenItemsClass = Class.forName("io.th0rgal.oraxen.api.OraxenItems");
                    Method getItemByIdMethod = oraxenItemsClass.getMethod("getItemById", String.class);
                    getItemByIdMethod.setAccessible(true);
                    Object oraxenItem = getItemByIdMethod.invoke(null, itemID);
                    if (oraxenItem != null) {
                        Method getReferenceCloneMethod = oraxenItem.getClass().getMethod("getReferenceClone", new Class[0]);
                        getReferenceCloneMethod.setAccessible(true);
                        ItemStack stack2 = (ItemStack)getReferenceCloneMethod.invoke(oraxenItem, new Object[0]);
                        if (stack2 != null) {
                            s = stack2;
                            normalCreation = false;
                        }
                    }
                }
                catch (Exception e) {
                    this.plugin.debug(e, null);
                }
            }
            if (matraw.split("\\s")[0].equalsIgnoreCase("itemsadder=") && (stack = CustomStack.getInstance((String)(namespaceID = matraw.split("\\s")[1]))) != null) {
                s = stack.getItemStack().clone();
                normalCreation = false;
            }
            if (matraw.split("\\s")[0].equalsIgnoreCase("mmo=") && this.plugin.getServer().getPluginManager().isPluginEnabled("MMOItems")) {
                String itemType = matraw.split("\\s")[1];
                String itemID = matraw.split("\\s")[2];
                ItemManager itemManager = MMOItems.plugin.getItems();
                MMOItem mmoitem = itemManager.getMMOItem(MMOItems.plugin.getTypes().get(itemType), itemID);
                s = mmoitem.newBuilder().build();
                normalCreation = false;
            }
            if (matraw.split("\\s")[0].equalsIgnoreCase("book=")) {
                s = new ItemStack(Material.WRITTEN_BOOK);
                BookMeta bookMeta = (BookMeta)s.getItemMeta();
                bookMeta.setTitle(matraw.split("\\s")[1]);
                bookMeta.setAuthor(matraw.split("\\s")[1]);
                List<String> bookLines = this.plugin.tex.placeholdersList(panel, position, p, itemSection.getStringList("write"), true);
                String result = bookLines.stream().map(String::valueOf).collect(Collectors.joining("\n" + ChatColor.RESET, "", ""));
                bookMeta.setPages(new String[]{result});
                s.setItemMeta((ItemMeta)bookMeta);
                normalCreation = false;
            }
            if (matraw.split("\\s")[0].equalsIgnoreCase("cpi=")) {
                s = this.makeCustomItemFromConfig(panel, position, panel.getConfig().getConfigurationSection("custom-item." + matraw.split("\\s")[1]), p, true, true, false);
                normalCreation = false;
            }
            if (normalCreation) {
                s = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)mat)), 1, id);
            }
            if (!(skullname.equals("no skull") || skullname.equals("hdb") || matraw.split("\\s")[0].equalsIgnoreCase("cpo="))) {
                try {
                    if (matraw.split("\\s")[1].equalsIgnoreCase("self")) {
                        SkullMeta meta = (SkullMeta)s.getItemMeta();
                        if (!this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                            try {
                                assert (meta != null);
                                meta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)UUID.fromString(skullname)));
                            }
                            catch (Exception var23) {
                                p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " material: cps= self"));
                                this.plugin.debug(var23, p);
                            }
                        } else {
                            meta.setOwner(p.getName());
                        }
                        s.setItemMeta((ItemMeta)meta);
                    } else {
                        s = this.plugin.tex.placeholdersNoColour(panel, position, p, matraw.split("\\s")[1]).length() <= 16 ? this.plugin.customHeads.getPlayerHead(this.plugin.tex.placeholdersNoColour(panel, position, p, matraw.split("\\s")[1])) : this.plugin.customHeads.getCustomHead(this.plugin.tex.placeholdersNoColour(panel, position, p, matraw.split("\\s")[1]));
                    }
                }
                catch (Exception var32) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " head material: Could not load skull"));
                    this.plugin.debug(var32, p);
                }
            }
            if (!skullname.equals("no skull") && matraw.split("\\s")[0].equalsIgnoreCase("cpo=")) {
                SkullMeta cpoMeta = (SkullMeta)s.getItemMeta();
                assert (cpoMeta != null);
                cpoMeta.setOwningPlayer(Bukkit.getOfflinePlayer((UUID)Objects.requireNonNull(Bukkit.getPlayer((String)matraw.split("\\s")[1])).getUniqueId()));
                s.setItemMeta((ItemMeta)cpoMeta);
            }
            if (skullname.equals("hdb")) {
                if (this.plugin.getServer().getPluginManager().isPluginEnabled("HeadDatabase")) {
                    HeadDatabaseAPI api = new HeadDatabaseAPI();
                    try {
                        s = api.getItemHead(matraw.split("\\s")[1].trim());
                    }
                    catch (Exception var22) {
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " hdb: could not load skull!"));
                        this.plugin.debug(var22, p);
                    }
                } else {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + "Download HeadDatabaseHook from Spigot to use this feature!"));
                }
            }
            if (itemSection.contains("itemType")) {
                if (itemSection.getStringList("itemType").contains("noAttributes")) {
                    hideAttributes = true;
                }
                if (itemSection.getStringList("itemType").contains("placeable")) {
                    addNBT = false;
                }
            }
            if (itemSection.contains("nbt")) {
                this.plugin.nbt.applyNBTRecursively(s, itemSection.getConfigurationSection("nbt"), p, panel, position);
            }
            if (addNBT) {
                this.plugin.nbt.setNBT(s, "CommandPanelsItem", "boolean_true");
            }
            if (itemSection.contains("enchanted")) {
                try {
                    if (itemSection.isList("enchanted")) {
                        ItemMeta EnchantMeta = s.getItemMeta();
                        assert (EnchantMeta != null);
                        for (Object enchantment : itemSection.getStringList("enchanted")) {
                            if (((String)enchantment).equalsIgnoreCase("true")) {
                                EnchantMeta.addEnchant(Enchantment.KNOCKBACK, 1, false);
                                EnchantMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                                continue;
                            }
                            EnchantMeta.addEnchant(Objects.requireNonNull(EnchantmentWrapper.getByKey((NamespacedKey)NamespacedKey.minecraft((String)((String)enchantment).split("\\s")[0].toLowerCase()))), Integer.parseInt(((String)enchantment).split("\\s")[1]), true);
                        }
                        s.setItemMeta(EnchantMeta);
                    }
                }
                catch (Exception ench) {
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " enchanted: " + itemSection.getString("enchanted")));
                    this.plugin.debug(ench, p);
                }
            }
            if (itemSection.contains("customdata")) {
                ItemMeta customMeta = s.getItemMeta();
                assert (customMeta != null);
                customMeta.setCustomModelData(Integer.valueOf(Integer.parseInt(this.plugin.tex.placeholders(panel, position, p, itemSection.getString("customdata")))));
                s.setItemMeta(customMeta);
            }
            try {
                if (itemSection.contains("banner")) {
                    BannerMeta bannerMeta = (BannerMeta)s.getItemMeta();
                    ArrayList<Pattern> patterns = new ArrayList<Pattern>();
                    for (String temp : itemSection.getStringList("banner")) {
                        temp = this.plugin.tex.placeholdersNoColour(panel, position, p, temp);
                        String[] dyePattern = temp.split(",");
                        patterns.add(new Pattern(DyeColor.valueOf((String)dyePattern[0]), PatternType.valueOf((String)dyePattern[1])));
                    }
                    bannerMeta.setPatterns(patterns);
                    s.setItemMeta((ItemMeta)bannerMeta);
                }
            }
            catch (Exception bannerMeta) {
                // empty catch block
            }
            if (itemSection.contains("leatherarmor")) {
                try {
                    if (s.getType() == Material.LEATHER_BOOTS || s.getType() == Material.LEATHER_LEGGINGS || s.getType() == Material.LEATHER_CHESTPLATE || s.getType() == Material.LEATHER_HELMET || s.getType() == Material.matchMaterial((String)"LEATHER_HORSE_ARMOR")) {
                        LeatherArmorMeta leatherMeta = (LeatherArmorMeta)s.getItemMeta();
                        String colourCode = this.plugin.tex.placeholdersNoColour(panel, position, p, itemSection.getString("leatherarmor"));
                        assert (colourCode != null);
                        if (!colourCode.contains(",")) {
                            assert (leatherMeta != null);
                            leatherMeta.setColor(this.plugin.colourCodes.get(colourCode.toUpperCase()));
                        } else {
                            int[] colorRGB = new int[]{255, 255, 255};
                            int count = 0;
                            for (String colourNum : colourCode.split(",")) {
                                colorRGB[count] = Integer.parseInt(colourNum);
                                ++count;
                            }
                            assert (leatherMeta != null);
                            leatherMeta.setColor(Color.fromRGB((int)colorRGB[0], (int)colorRGB[1], (int)colorRGB[2]));
                        }
                        s.setItemMeta((ItemMeta)leatherMeta);
                    }
                }
                catch (Exception er) {
                    this.plugin.debug(er, p);
                    p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " leatherarmor: " + itemSection.getString("leatherarmor")));
                }
            }
            if (itemSection.contains("potion")) {
                String[] effectType = this.plugin.tex.placeholdersNoColour(panel, position, p, itemSection.getString("potion")).split("\\s");
                if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_19) || this.plugin.legacy.MAJOR_VERSION == MinecraftVersions.v1_20 && this.plugin.legacy.MINOR_VERSION <= 4) {
                    if (this.plugin.legacy.MAJOR_VERSION.equals((Object)MinecraftVersions.v1_8)) {
                        this.plugin.classicPotion.applyPotionEffect(p, s, effectType);
                    } else {
                        this.plugin.legacyPotion.applyPotionEffect(p, s, effectType);
                    }
                } else {
                    try {
                        PotionMeta potionMeta = (PotionMeta)s.getItemMeta();
                        assert (potionMeta != null);
                        PotionType newData = PotionType.valueOf((String)effectType[0].toUpperCase());
                        potionMeta.setBasePotionType(newData);
                        s.setItemMeta((ItemMeta)potionMeta);
                    }
                    catch (Exception er) {
                        this.plugin.debug(er, p);
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.RED + this.plugin.config.getString("config.format.error") + " potion: " + itemSection.getString("potion")));
                    }
                }
            }
            if (itemSection.contains("potion-color") && this.plugin.legacy.MAJOR_VERSION.greaterThanOrEqualTo(MinecraftVersions.v1_11)) {
                String[] rgb = Objects.requireNonNull(itemSection.getString("potion-color")).split(",");
                Color color = Color.fromRGB((int)Integer.parseInt(rgb[0]), (int)Integer.parseInt(rgb[1]), (int)Integer.parseInt(rgb[2]));
                PotionMeta potionMeta = (PotionMeta)s.getItemMeta();
                assert (potionMeta != null);
                potionMeta.setColor(color);
                s.setItemMeta((ItemMeta)potionMeta);
            }
            if (itemSection.contains("damage")) {
                if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                    try {
                        s.setDurability(Short.parseShort(Objects.requireNonNull(this.plugin.tex.placeholders(panel, position, p, itemSection.getString("damage")))));
                    }
                    catch (Exception e) {
                        this.plugin.debug(e, p);
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " damage: " + itemSection.getString("damage")));
                    }
                } else if (itemSection.getString("damage").equalsIgnoreCase("-1")) {
                    ItemMeta unbreak = s.getItemMeta();
                    unbreak.setUnbreakable(true);
                    s.setItemMeta(unbreak);
                } else {
                    try {
                        Damageable itemDamage = (Damageable)s.getItemMeta();
                        itemDamage.setDamage(Integer.parseInt(Objects.requireNonNull(this.plugin.tex.placeholders(panel, position, p, itemSection.getString("damage")))));
                        s.setItemMeta((ItemMeta)itemDamage);
                    }
                    catch (Exception e) {
                        this.plugin.debug(e, p);
                        p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " damage: " + itemSection.getString("damage")));
                    }
                }
            }
            if (this.plugin.legacy.MAJOR_VERSION.greaterThanOrEqualTo(MinecraftVersions.v1_20) && itemSection.contains("trim") && (trimList = (trim = itemSection.getString("trim")).split("\\s")).length == 2) {
                String trimMaterialString = trimList[0].toLowerCase();
                String trimPatternString = trimList[1].toLowerCase();
                if (this.isTrimMaterial(trimMaterialString) && this.isTrimPattern(trimPatternString) && this.isArmor(s)) {
                    TrimMaterial trimMaterial = (TrimMaterial)Registry.TRIM_MATERIAL.get(Objects.requireNonNull(NamespacedKey.fromString((String)("minecraft:" + trimMaterialString))));
                    TrimPattern trimPattern = (TrimPattern)Registry.TRIM_PATTERN.get(Objects.requireNonNull(NamespacedKey.fromString((String)("minecraft:" + trimPatternString))));
                    ArmorMeta armorMeta = (ArmorMeta)s.getItemMeta();
                    armorMeta.setTrim(new ArmorTrim(trimMaterial, trimPattern));
                    s.setItemMeta((ItemMeta)armorMeta);
                }
            }
            if (itemSection.contains("stack")) {
                s.setAmount((int)Double.parseDouble(Objects.requireNonNull(this.plugin.tex.placeholders(panel, position, p, itemSection.getString("stack")))));
            }
            if (itemSection.contains("refresh-commands") && this.plugin.openPanels.hasPanelOpen(p.getName(), panel.getName(), position)) {
                try {
                    this.plugin.commandRunner.runCommands(panel, position, p, itemSection.getStringList("refresh-commands"), null);
                }
                catch (Exception ex) {
                    this.plugin.debug(ex, p);
                }
            }
        }
        catch (IllegalArgumentException | NullPointerException var33) {
            this.plugin.debug(var33, p);
            p.sendMessage(this.plugin.tex.colour(this.plugin.tag + this.plugin.config.getString("config.format.error") + " material: " + itemSection.getString("material")));
            return null;
        }
        s = this.plugin.setName(panel, s, itemSection.getString("name"), itemSection.getStringList("lore"), p, placeholders, colours, hideAttributes);
        return s;
    }

    public ItemStack makeCustomItemFromConfig(Panel panel, PanelPosition position, ConfigurationSection itemSection, Player p, boolean placeholders, boolean colours, boolean addNBT) {
        String section = this.plugin.has.hasSection(panel, position, itemSection, p);
        if (!section.equals("")) {
            itemSection = itemSection.getConfigurationSection(section.substring(1));
        }
        return this.plugin.itemCreate.makeItemFromConfig(panel, position, itemSection, p, placeholders, colours, addNBT);
    }

    public YamlConfiguration generatePanelFile(String panelName, Inventory inv, YamlConfiguration file) {
        for (int i = 0; inv.getSize() > i; ++i) {
            ItemStack cont = inv.getItem(i);
            try {
                if (cont == null && file.contains("panels." + panelName + ".item." + i) && !file.getString("panels." + panelName + ".item." + i + ".material").equalsIgnoreCase("AIR")) {
                    file.set("panels." + panelName + ".item." + i, null);
                    continue;
                }
                if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12) && cont.getDurability() != 0 && !cont.getType().toString().equals("SKULL_ITEM")) {
                    file.set("panels." + panelName + ".item." + i + ".ID", (Object)cont.getDurability());
                }
                if (file.contains("panels." + panelName + ".item." + i + ".material")) {
                    if (Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("%") || Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("=")) {
                        if (!this.plugin.getHeads.ifSkullOrHead(cont.getType().toString())) {
                            file.set("panels." + panelName + ".item." + i + ".material", (Object)cont.getType().toString());
                        }
                    } else {
                        file.set("panels." + panelName + ".item." + i + ".material", (Object)cont.getType().toString());
                    }
                } else {
                    file.set("panels." + panelName + ".item." + i + ".material", (Object)cont.getType().toString());
                }
                if (this.plugin.getHeads.ifSkullOrHead(cont.getType().toString()) && !Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("%") && !Objects.requireNonNull(file.getString("panels." + panelName + ".item." + i + ".material")).contains("=")) {
                    file.set("panels." + panelName + ".item." + i + ".material", (Object)this.plugin.getHeads.playerHeadString());
                }
                try {
                    BannerMeta bannerMeta = (BannerMeta)cont.getItemMeta();
                    ArrayList<String> dyePattern = new ArrayList<String>();
                    for (Pattern pattern : bannerMeta.getPatterns()) {
                        dyePattern.add(pattern.getColor() + "," + pattern.getPattern());
                    }
                    file.set("panels." + panelName + ".item." + i + ".banner", dyePattern);
                }
                catch (Exception ignore) {
                    file.set("panels." + panelName + ".item." + i + ".banner", null);
                }
                try {
                    if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_19) || this.plugin.legacy.MAJOR_VERSION == MinecraftVersions.v1_20 && this.plugin.legacy.MINOR_VERSION <= 4) {
                        if (this.plugin.legacyPotion.retrievePotionData(cont) != null) {
                            file.set("panels." + panelName + ".item." + i + ".potion", (Object)this.plugin.legacyPotion.retrievePotionData(cont));
                        }
                    } else {
                        PotionMeta potionMeta = (PotionMeta)cont.getItemMeta();
                        assert (potionMeta != null);
                        String potionType = potionMeta.getBasePotionType().toString();
                        file.set("panels." + panelName + ".item." + i + ".potion", (Object)potionType);
                    }
                }
                catch (Exception ignore) {
                    file.set("panels." + panelName + ".item." + i + ".potion", null);
                }
                file.set("panels." + panelName + ".item." + i + ".stack", (Object)cont.getAmount());
                if (!cont.getEnchantments().isEmpty()) {
                    Map enchantments = cont.getEnchantments();
                    ArrayList<String> newEnchantments = new ArrayList<String>();
                    for (Enchantment enchantment : enchantments.keySet()) {
                        newEnchantments.add(enchantment.getKey().getKey() + " " + enchantments.get(enchantment));
                    }
                    file.set("panels." + panelName + ".item." + i + ".enchanted", newEnchantments);
                }
                file.set("panels." + panelName + ".item." + i + ".name", (Object)Objects.requireNonNull(cont.getItemMeta()).getDisplayName());
                file.set("panels." + panelName + ".item." + i + ".lore", (Object)Objects.requireNonNull(cont.getItemMeta()).getLore());
                if (!this.plugin.legacy.MAJOR_VERSION.greaterThanOrEqualTo(MinecraftVersions.v1_14)) continue;
                file.set("panels." + panelName + ".item." + i + ".customdata", (Object)Objects.requireNonNull(cont.getItemMeta()).getCustomModelData());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return file;
    }

    public boolean isIdentical(ItemStack one, ItemStack two, Boolean nbtCheck) {
        if (one.getType() != two.getType()) {
            return false;
        }
        if (one.hasItemMeta() != two.hasItemMeta()) {
            return false;
        }
        try {
            if (!one.getItemMeta().getDisplayName().equals(two.getItemMeta().getDisplayName()) && one.getItemMeta().hasDisplayName()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12) && one.getDurability() != two.getDurability()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!one.getItemMeta().getLore().equals(two.getItemMeta().getLore()) && one.getItemMeta().hasLore()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.plugin.legacy.MAJOR_VERSION.greaterThanOrEqualTo(MinecraftVersions.v1_14) && one.getItemMeta().getCustomModelData() != two.getItemMeta().getCustomModelData() && one.getItemMeta().hasCustomModelData()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nbtCheck.booleanValue()) {
            try {
                if (!this.plugin.nbt.hasSameNBT(one, two)) {
                    return false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_12)) {
                if (one.getDurability() != two.getDurability()) {
                    return false;
                }
            } else {
                Damageable tempOne = (Damageable)one.getItemMeta();
                Damageable tempTwo = (Damageable)two.getItemMeta();
                if (tempOne.getDamage() != tempTwo.getDamage()) {
                    return false;
                }
            }
        }
        catch (Exception tempOne) {
            // empty catch block
        }
        try {
            if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_19) || this.plugin.legacy.MAJOR_VERSION == MinecraftVersions.v1_20 && this.plugin.legacy.MINOR_VERSION <= 4) {
                String potionTwo;
                String potionOne = this.plugin.legacyPotion.retrievePotionData(one);
                if (!potionOne.equals(potionTwo = this.plugin.legacyPotion.retrievePotionData(two))) {
                    return false;
                }
            } else {
                PotionMeta meta1 = (PotionMeta)one.getItemMeta();
                PotionMeta meta2 = (PotionMeta)two.getItemMeta();
                if (meta1.getBasePotionType().toString().compareTo(meta2.getBasePotionType().toString()) != 0) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return one.getEnchantments() != two.getEnchantments() || one.getEnchantments().isEmpty();
    }

    private boolean isTrimMaterial(String material) {
        List<String> availableMaterial = Arrays.asList("AMETHYST", "COPPER", "DIAMOND", "EMERALD", "GOLD", "IRON", "LAPIS", "NETHERITE", "QUARTZ", "REDSTONE");
        return availableMaterial.contains(material.toUpperCase());
    }

    private boolean isTrimPattern(String pattern) {
        List<String> availablePattern = Arrays.asList("COAST", "DUNE", "EYE", "HOST", "RAISER", "RIB", "SENTRY", "SHAPER", "SILENCE", "SNOUT", "SPIRE", "TIDE", "VEX", "WARD", "WAYFINDER", "WILD");
        return availablePattern.contains(pattern.toUpperCase());
    }

    private boolean isArmor(ItemStack stack) {
        return EnchantmentTarget.ARMOR.includes(stack);
    }
}

