/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.classresources.customheads.methods;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.classresources.customheads.SavedCustomHead;
import me.rockyhawk.commandpanels.ioclasses.legacy.MinecraftVersions;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;

public class CustomHeadGameProfile {
    CommandPanels plugin;
    public HashMap<String, SavedCustomHead> savedCustomHeads = new HashMap();

    public CustomHeadGameProfile(CommandPanels pl) {
        this.plugin = pl;
    }

    public ItemStack getPlayerHead(String name) {
        int id = 0;
        if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_15)) {
            id = 3;
        }
        if (this.savedCustomHeads.containsKey(name)) {
            if (!this.savedCustomHeads.get((Object)name).isValid && System.currentTimeMillis() - this.savedCustomHeads.get((Object)name).lastAttempt < 60000L) {
                return new ItemStack(Material.valueOf((String)this.plugin.getHeads.playerHeadString()));
            }
            if (this.savedCustomHeads.get((Object)name).isValid) {
                return this.savedCustomHeads.get((Object)name).headItem;
            }
        }
        ItemStack itemStack = new ItemStack(Material.matchMaterial((String)this.plugin.getHeads.playerHeadString()), 1, (short)id);
        SkullMeta meta = (SkullMeta)itemStack.getItemMeta();
        meta.setOwner(name);
        itemStack.setItemMeta((ItemMeta)meta);
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                if (this.plugin.debug.consoleDebug) {
                    this.plugin.getServer().getConsoleSender().sendMessage(this.plugin.tex.colour(this.plugin.tag + ChatColor.WHITE + "Download & Cache Head Texture for " + name));
                }
                URL uuidUrl = new URL("https://api.mojang.com/users/profiles/minecraft/" + name);
                URLConnection uuidConnection = uuidUrl.openConnection();
                uuidConnection.setConnectTimeout(2000);
                uuidConnection.setReadTimeout(2000);
                String uuidReader = new Scanner(uuidConnection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A").next();
                String uuid = uuidReader.split("\"id\" : \"")[1].split("\"")[0];
                URL texturesUrl = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid);
                URLConnection texturesConnection = texturesUrl.openConnection();
                texturesConnection.setConnectTimeout(2000);
                texturesConnection.setReadTimeout(2000);
                String valueReader = new Scanner(texturesConnection.getInputStream(), StandardCharsets.UTF_8.name()).useDelimiter("\\A").next();
                String value = valueReader.split("\"value\" : \"")[1].split("\"")[0];
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    itemStack.setItemMeta(this.getCustomHead(name, value).getItemMeta());
                    this.savedCustomHeads.put(name, new SavedCustomHead(itemStack, value, true));
                });
            }
            catch (Exception ignore) {
                Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                    if (this.savedCustomHeads.containsKey(name) && this.savedCustomHeads.get((Object)name).isValid) {
                        return;
                    }
                    this.savedCustomHeads.put(name, new SavedCustomHead(null, null, false));
                });
            }
        });
        return itemStack;
    }

    public ItemStack getCustomHead(String playerName, String b64stringtexture) {
        if (this.savedCustomHeads.containsKey(playerName)) {
            if (this.savedCustomHeads.get((Object)playerName).base64 != null) {
                return this.savedCustomHeads.get((Object)playerName).headItem;
            }
            this.savedCustomHeads.get((Object)playerName).isValid = false;
        }
        Iterator<Map.Entry<String, SavedCustomHead>> iterator = this.savedCustomHeads.entrySet().iterator();
        while (this.savedCustomHeads.size() > 2000 && iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        return this.getCustomHead(b64stringtexture);
    }

    public ItemStack getCustomHead(String b64stringtexture) {
        Field profileField;
        GameProfile profile = new GameProfile(UUID.randomUUID(), "");
        PropertyMap propertyMap = profile.getProperties();
        if (propertyMap == null) {
            throw new IllegalStateException("Profile doesn't contain a property map");
        }
        propertyMap.put((Object)"textures", (Object)new Property("textures", b64stringtexture));
        int id = 0;
        if (this.plugin.legacy.MAJOR_VERSION.lessThanOrEqualTo(MinecraftVersions.v1_15)) {
            id = 3;
        }
        ItemStack head = new ItemStack(Material.matchMaterial((String)this.plugin.getHeads.playerHeadString()), 1, (short)id);
        ItemMeta headMeta = head.getItemMeta();
        assert (headMeta != null);
        Method setProfileMethod = null;
        try {
            profileField = headMeta.getClass().getDeclaredField("profile");
            Field serializedProfileField = headMeta.getClass().getDeclaredField("serializedProfile");
            profileField.setAccessible(true);
            serializedProfileField.setAccessible(true);
            profileField.set(headMeta, profile);
            serializedProfileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e1) {
            try {
                setProfileMethod = headMeta.getClass().getDeclaredMethod("setProfile", GameProfile.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (SecurityException e1) {
            // empty catch block
        }
        try {
            if (setProfileMethod == null) {
                profileField = headMeta.getClass().getDeclaredField("profile");
                profileField.setAccessible(true);
                profileField.set(headMeta, profile);
            } else {
                setProfileMethod.setAccessible(true);
                setProfileMethod.invoke((Object)headMeta, profile);
            }
        }
        catch (Exception e1) {
            this.plugin.debug(e1, null);
        }
        head.setItemMeta(headMeta);
        return head;
    }
}

