/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.commands.impl.cloud;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.commands.PlaceholderCommand;
import me.clip.placeholderapi.configuration.ExpansionSort;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.cloud.CloudExpansion;
import me.clip.placeholderapi.libs.kyori.adventure.text.Component;
import me.clip.placeholderapi.libs.kyori.adventure.text.TextComponent;
import me.clip.placeholderapi.libs.kyori.adventure.text.event.ClickEvent;
import me.clip.placeholderapi.libs.kyori.adventure.text.event.HoverEvent;
import me.clip.placeholderapi.libs.kyori.adventure.text.format.NamedTextColor;
import me.clip.placeholderapi.libs.kyori.adventure.text.format.TextColor;
import me.clip.placeholderapi.libs.kyori.adventure.text.format.TextDecoration;
import me.clip.placeholderapi.util.Format;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class CommandECloudExpansionList
extends PlaceholderCommand {
    private static final int PAGE_SIZE = 10;
    @NotNull
    private static final Function<CloudExpansion, Object> EXPANSION_NAME = expansion -> (expansion.shouldUpdate() ? "&6" : (expansion.hasExpansion() ? "&a" : "&7")) + expansion.getName();
    @NotNull
    private static final Function<CloudExpansion, Object> EXPANSION_AUTHOR = expansion -> "&f" + expansion.getAuthor();
    @NotNull
    private static final Function<CloudExpansion, Object> EXPANSION_VERIFIED = expansion -> expansion.isVerified() ? "&aY" : "&cN";
    @NotNull
    private static final Function<CloudExpansion, Object> EXPANSION_LATEST_VERSION = expansion -> "&f" + expansion.getLatestVersion();
    @NotNull
    private static final Function<CloudExpansion, Object> EXPANSION_CURRENT_VERSION = expansion -> "&f" + PlaceholderAPIPlugin.getInstance().getLocalExpansionManager().findExpansionByName(expansion.getName()).map(PlaceholderExpansion::getVersion).orElse("Unknown");
    private static final @Unmodifiable Set<String> OPTIONS = ImmutableSet.of((Object)"all", (Object)"installed");

    public CommandECloudExpansionList() {
        super("list", new String[0]);
    }

    @NotNull
    private static Collection<CloudExpansion> getExpansions(@NotNull String target, @NotNull PlaceholderAPIPlugin plugin) {
        switch (target.toLowerCase(Locale.ROOT)) {
            case "all": {
                return plugin.getCloudExpansionManager().getCloudExpansions().values();
            }
            case "installed": {
                return plugin.getCloudExpansionManager().getCloudExpansionsInstalled().values();
            }
        }
        return plugin.getCloudExpansionManager().getCloudExpansionsByAuthor(target).values();
    }

    @NotNull
    private static List<CloudExpansion> getPage(@NotNull List<CloudExpansion> expansions, int page) {
        int head = page * 10;
        int tail = Math.min(expansions.size(), head + 10);
        if (expansions.size() < head) {
            return Collections.emptyList();
        }
        return expansions.subList(head, tail);
    }

    public static void addExpansionTitle(@NotNull StringBuilder builder, @NotNull String target, int page) {
        switch (target.toLowerCase(Locale.ROOT)) {
            case "all": {
                builder.append("&bAll Expansions");
                break;
            }
            case "installed": {
                builder.append("&bInstalled Expansions");
                break;
            }
            default: {
                builder.append("&bExpansions by &f").append(target);
            }
        }
        if (page == -1) {
            builder.append('\n');
            return;
        }
        builder.append(" &bPage&7: &a").append(page).append("&r");
    }

    private static Component getMessage(@NotNull List<CloudExpansion> expansions, int page, int limit, @NotNull String target) {
        SimpleDateFormat format = PlaceholderAPIPlugin.getDateFormat();
        TextComponent.Builder message = Component.text();
        for (int index = 0; index < expansions.size(); ++index) {
            CloudExpansion expansion = expansions.get(index);
            TextComponent.Builder line = Component.text();
            int expansionNumber = index + (page - 1) * 10 + 1;
            line.append((Component)Component.text(expansionNumber + ". ", (TextColor)NamedTextColor.DARK_GRAY));
            NamedTextColor expansionColour = expansion.shouldUpdate() ? NamedTextColor.GOLD : (expansion.hasExpansion() ? NamedTextColor.GREEN : NamedTextColor.GRAY);
            line.append((Component)Component.text(expansion.getName(), (TextColor)expansionColour));
            line.clickEvent(ClickEvent.suggestCommand("/papi ecloud download " + expansion.getName()));
            TextComponent.Builder hoverText = (TextComponent.Builder)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text("Click to download this expansion!", (TextColor)NamedTextColor.AQUA).append(Component.newline())).append(Component.newline())).append(Component.text("Author: ", (TextColor)NamedTextColor.AQUA))).append(Component.text(expansion.getAuthor(), (TextColor)NamedTextColor.WHITE))).append(Component.newline())).append(Component.text("Verified: ", (TextColor)NamedTextColor.AQUA))).append(Component.text(expansion.isVerified() ? "\u2714" : "\u274c", (TextColor)(expansion.isVerified() ? NamedTextColor.GREEN : NamedTextColor.RED), TextDecoration.BOLD))).append(Component.newline())).append(Component.text("Released: ", (TextColor)NamedTextColor.AQUA))).append(Component.text(format.format(expansion.getLastUpdate()), (TextColor)NamedTextColor.WHITE))).toBuilder();
            Optional.ofNullable(expansion.getDescription()).filter(description -> !description.isEmpty()).ifPresent(description -> {
                TextComponent.Builder cfr_ignored_0 = (TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)hoverText.append((Component)Component.newline())).append((Component)Component.newline())).append((Component)Component.text(description.replace("\r", "").trim(), (TextColor)NamedTextColor.WHITE));
            });
            line.hoverEvent(HoverEvent.showText((Component)hoverText.build()));
            if (index != expansions.size() - 1) {
                line.append((Component)Component.newline());
            }
            message.append((Component)line.build());
        }
        if (limit > 1) {
            message.append((Component)Component.newline());
            TextComponent.Builder left = (TextComponent.Builder)Component.text("\u25c0", (TextColor)(page > 1 ? NamedTextColor.GRAY : NamedTextColor.DARK_GRAY)).toBuilder();
            if (page > 1) {
                left.clickEvent(ClickEvent.runCommand("/papi ecloud list " + target + " " + (page - 1)));
            }
            TextComponent.Builder right = (TextComponent.Builder)Component.text("\u25b6", (TextColor)(page < limit ? NamedTextColor.GRAY : NamedTextColor.DARK_GRAY)).toBuilder();
            if (page < limit) {
                right.clickEvent(ClickEvent.runCommand("/papi ecloud list " + target + " " + (page + 1)));
            }
            message.append(left, Component.text(" " + page + " ", (TextColor)NamedTextColor.GREEN), right);
        }
        return message.build();
    }

    private static void addExpansionTable(@NotNull List<CloudExpansion> expansions, @NotNull StringBuilder message, int startIndex, @NotNull String versionTitle, @NotNull Function<CloudExpansion, Object> versionFunction) {
        LinkedHashMap<String, Function<CloudExpansion, Object>> functions = new LinkedHashMap<String, Function<CloudExpansion, Object>>();
        AtomicInteger counter = new AtomicInteger(startIndex);
        functions.put("&f", expansion -> "&8" + counter.getAndIncrement() + ".");
        functions.put("&9Name", EXPANSION_NAME);
        functions.put("&9Author", EXPANSION_AUTHOR);
        functions.put("&9Verified", EXPANSION_VERIFIED);
        functions.put(versionTitle, versionFunction);
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        rows.add(0, new ArrayList(functions.keySet()));
        for (CloudExpansion expansion2 : expansions) {
            rows.add(functions.values().stream().map(function -> function.apply(expansion2)).map(Objects::toString).collect(Collectors.toList()));
        }
        List table = Format.tablify(Format.Align.LEFT, rows).orElse(Collections.emptyList());
        if (table.isEmpty()) {
            return;
        }
        table.add(1, "&8" + Strings.repeat((String)"-", (int)(((String)table.get(0)).length() - ((List)rows.get(0)).size() * 2)));
        message.append(String.join((CharSequence)"\n", table));
    }

    @Override
    public void evaluate(@NotNull PlaceholderAPIPlugin plugin, @NotNull CommandSender sender, @NotNull String alias, @NotNull @Unmodifiable List<String> params) {
        int page;
        if (params.isEmpty()) {
            Msg.msg(sender, "&cYou must specify an option. [all, {author}, installed]");
            return;
        }
        boolean installed = params.get(0).equalsIgnoreCase("installed");
        ArrayList expansions = Lists.newArrayList(CommandECloudExpansionList.getExpansions(params.get(0), plugin));
        if (expansions.isEmpty()) {
            Msg.msg(sender, "&cNo expansions available to list.");
            return;
        }
        expansions.sort(plugin.getPlaceholderAPIConfig().getExpansionSort().orElse(ExpansionSort.LATEST));
        if (!(sender instanceof Player) && params.size() < 2) {
            StringBuilder builder = new StringBuilder();
            CommandECloudExpansionList.addExpansionTitle(builder, params.get(0), -1);
            CommandECloudExpansionList.addExpansionTable(expansions, builder, 1, installed ? "&9Version" : "&9Latest Version", installed ? EXPANSION_CURRENT_VERSION : EXPANSION_LATEST_VERSION);
            Msg.msg(sender, builder.toString());
            return;
        }
        if (params.size() < 2) {
            page = 1;
        } else {
            Integer parsed = Ints.tryParse((String)params.get(1));
            if (parsed == null) {
                Msg.msg(sender, "&cPage number must be an integer.");
                return;
            }
            int limit = (int)Math.ceil((double)expansions.size() / 10.0);
            if (parsed < 1 || parsed > limit) {
                Msg.msg(sender, "&cPage number must be in the range &8[&a1&7..&a" + limit + "&8]");
                return;
            }
            page = parsed;
        }
        StringBuilder builder = new StringBuilder();
        List<CloudExpansion> values = CommandECloudExpansionList.getPage(expansions, page - 1);
        CommandECloudExpansionList.addExpansionTitle(builder, params.get(0), page);
        if (!(sender instanceof Player)) {
            CommandECloudExpansionList.addExpansionTable(values, builder, (page - 1) * 10 + 1, installed ? "&9Version" : "&9Latest Version", installed ? EXPANSION_CURRENT_VERSION : EXPANSION_LATEST_VERSION);
            Msg.msg(sender, builder.toString());
            return;
        }
        Msg.msg(sender, builder.toString());
        int limit = (int)Math.ceil((double)expansions.size() / 10.0);
        Component message = CommandECloudExpansionList.getMessage(values, page, limit, params.get(0));
        plugin.getAdventure().player((Player)sender).sendMessage(message);
    }

    @Override
    public void complete(@NotNull PlaceholderAPIPlugin plugin, @NotNull CommandSender sender, @NotNull String alias, @NotNull @Unmodifiable List<String> params, @NotNull List<String> suggestions) {
        if (params.size() > 2) {
            return;
        }
        if (params.size() <= 1) {
            CommandECloudExpansionList.suggestByParameter(Sets.union(OPTIONS, plugin.getCloudExpansionManager().getCloudExpansionAuthors()).stream(), suggestions, params.isEmpty() ? null : params.get(0));
            return;
        }
        CommandECloudExpansionList.suggestByParameter(IntStream.rangeClosed(1, (int)Math.ceil((double)CommandECloudExpansionList.getExpansions(params.get(0), plugin).size() / 10.0)).mapToObj(Objects::toString), suggestions, params.get(1));
    }
}

