/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import me.ashtheking.currency.Currency;
import me.ashtheking.currency.CurrencyList;
import net.milkbowl.vault.economy.AbstractEconomy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_MultiCurrency
extends AbstractEconomy {
    private final Logger log;
    private final String name = "MultiCurrency";
    private Plugin plugin = null;
    private Currency economy = null;

    public Economy_MultiCurrency(Plugin plugin) {
        Plugin multiCurrency;
        this.plugin = plugin;
        this.log = plugin.getLogger();
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (multiCurrency = plugin.getServer().getPluginManager().getPlugin("MultiCurrency")) != null && multiCurrency.isEnabled()) {
            this.economy = (Currency)multiCurrency;
            this.log.info(String.format("[Economy] %s hooked.", "MultiCurrency"));
        }
    }

    @Override
    public String getName() {
        return "MultiCurrency";
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public double getBalance(String playerName) {
        double balance;
        double fBalance = balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
        return fBalance;
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot withdraw negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        if (!CurrencyList.hasEnough((String)playerName, (double)amount)) {
            errorMessage = "Insufficient funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        if (CurrencyList.subtract((String)playerName, (double)amount)) {
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
            double balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        errorMessage = "Error withdrawing funds";
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
        amount = 0.0;
        double balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        String errorMessage = null;
        if (amount < 0.0) {
            errorMessage = "Cannot deposit negative funds";
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
            amount = 0.0;
            double balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        if (CurrencyList.add((String)playerName, (double)amount)) {
            EconomyResponse.ResponseType type = EconomyResponse.ResponseType.SUCCESS;
            double balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
            return new EconomyResponse(amount, balance, type, errorMessage);
        }
        errorMessage = "Error withdrawing funds";
        EconomyResponse.ResponseType type = EconomyResponse.ResponseType.FAILURE;
        amount = 0.0;
        double balance = CurrencyList.getValue((String)((String)CurrencyList.maxCurrency((String)playerName)[0]), (String)playerName);
        return new EconomyResponse(amount, balance, type, errorMessage);
    }

    @Override
    public String format(double amount) {
        return String.format("%.2f %s", amount, "currency");
    }

    @Override
    public String currencyNameSingular() {
        return "currency";
    }

    @Override
    public String currencyNamePlural() {
        return "currency";
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "MultiCurrency does not support bank accounts");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return true;
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return false;
    }

    @Override
    public int fractionalDigits() {
        return -1;
    }

    @Override
    public boolean hasAccount(String playerName, String worldName) {
        return this.hasAccount(playerName);
    }

    @Override
    public double getBalance(String playerName, String world) {
        return this.getBalance(playerName);
    }

    @Override
    public boolean has(String playerName, String worldName, double amount) {
        return this.has(playerName, amount);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, String worldName, double amount) {
        return this.withdrawPlayer(playerName, amount);
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, String worldName, double amount) {
        return this.depositPlayer(playerName, amount);
    }

    @Override
    public boolean createPlayerAccount(String playerName, String worldName) {
        return this.createPlayerAccount(playerName);
    }

    public class EconomyServerListener
    implements Listener {
        Economy_MultiCurrency economy = null;

        public EconomyServerListener(Economy_MultiCurrency economy) {
            this.economy = economy;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin mcur;
            if (this.economy.economy == null && (mcur = event.getPlugin()).getDescription().getName().equals("MultiCurrency")) {
                this.economy.economy = (Currency)mcur;
                Economy_MultiCurrency.this.log.info(String.format("[Economy] %s hooked.", "MultiCurrency"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("MultiCurrency")) {
                this.economy.economy = null;
                Economy_MultiCurrency.this.log.info(String.format("[Economy] %s unhooked.", "MultiCurrency"));
            }
        }
    }
}

