/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.openpanelsmanager;

import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.api.PanelClosedEvent;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class UtilsPanelsLoader
implements Listener {
    CommandPanels plugin;

    public UtilsPanelsLoader(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onPlayerClosePanel(PlayerQuitEvent e) {
        this.plugin.openPanels.closePanelForLoader(e.getPlayer().getName(), PanelPosition.Top);
        Player p = e.getPlayer();
        p.updateInventory();
        this.plugin.openPanels.deleteCommandPanelsItems(p);
    }

    @EventHandler
    public void onPlayerClosePanel(InventoryCloseEvent e) {
        final String playerName = e.getPlayer().getName();
        if (!this.plugin.openPanels.openPanels.containsKey(playerName) || this.plugin.openPanels.skipPanelClose.contains(playerName)) {
            return;
        }
        if (this.plugin.openPanels.getOpenPanel(playerName, PanelPosition.Top).getConfig().contains("panelType") && this.plugin.openPanels.getOpenPanel(playerName, PanelPosition.Top).getConfig().getStringList("panelType").contains("unclosable")) {
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    if (UtilsPanelsLoader.this.plugin.openPanels.getOpenPanel(playerName, PanelPosition.Top) == null) {
                        return;
                    }
                    UtilsPanelsLoader.this.plugin.openPanels.getOpenPanel((String)playerName, (PanelPosition)PanelPosition.Top).isOpen = false;
                    Panel reopenedPanel = UtilsPanelsLoader.this.plugin.openPanels.getOpenPanel(playerName, PanelPosition.Top).copy();
                    reopenedPanel.placeholders.keys = UtilsPanelsLoader.this.plugin.openPanels.getOpenPanel((String)playerName, (PanelPosition)PanelPosition.Top).placeholders.keys;
                    reopenedPanel.open(Bukkit.getPlayer((String)playerName), PanelPosition.Top);
                }
            });
            return;
        }
        if (this.plugin.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Bottom)) {
            this.plugin.openPanels.panelCloseCommands(playerName, PanelPosition.Bottom, this.plugin.openPanels.getOpenPanel(playerName, PanelPosition.Bottom));
        }
        if (this.plugin.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Middle)) {
            this.plugin.openPanels.panelCloseCommands(playerName, PanelPosition.Middle, this.plugin.openPanels.getOpenPanel(playerName, PanelPosition.Middle));
        }
        this.plugin.openPanels.closePanelForLoader(e.getPlayer().getName(), PanelPosition.Top);
    }

    @EventHandler
    public void onInventoryItemClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            if (e.getCurrentItem() == null) {
                return;
            }
            if (e.getCurrentItem().getType() == Material.AIR) {
                return;
            }
            if (this.plugin.openPanels.isCommandPanelsItem(e.getCurrentItem())) {
                p.getInventory().remove(e.getCurrentItem());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void vanillaOpenedEvent(InventoryOpenEvent e) {
        if (e.isCancelled() && this.plugin.openPanels.hasPanelOpen(e.getPlayer().getName(), PanelPosition.Top)) {
            Panel closedPanel = this.plugin.openPanels.getOpenPanel(e.getPlayer().getName(), PanelPosition.Top);
            this.plugin.openPanels.removePlayer(e.getPlayer().getName());
            PanelClosedEvent closedEvent = new PanelClosedEvent(Bukkit.getPlayer((String)e.getPlayer().getName()), closedPanel, PanelPosition.Top);
            Bukkit.getPluginManager().callEvent((Event)closedEvent);
            if (this.plugin.config.contains("config.panel-snooper") && Objects.requireNonNull(this.plugin.config.getString("config.panel-snooper")).equalsIgnoreCase("true")) {
                Bukkit.getConsoleSender().sendMessage("[CommandPanels] " + e.getPlayer().getName() + "'s Panel was Force Closed");
            }
        }
    }
}

