/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viarewind.protocol.v1_8to1_7_6_10.rewriter;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.viarewind.ViaRewind;
import com.viaversion.viarewind.api.minecraft.math.AABB;
import com.viaversion.viarewind.api.minecraft.math.Ray3d;
import com.viaversion.viarewind.api.minecraft.math.RayTracing;
import com.viaversion.viarewind.api.minecraft.math.Vector3d;
import com.viaversion.viarewind.api.type.RewindTypes;
import com.viaversion.viarewind.api.type.version.Types1_7_6_10;
import com.viaversion.viarewind.protocol.v1_7_6_10to1_7_2_5.packet.ClientboundPackets1_7_2_5;
import com.viaversion.viarewind.protocol.v1_7_6_10to1_7_2_5.packet.ServerboundPackets1_7_2_5;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.Protocol1_8To1_7_6_10;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.data.VirtualHologramEntity;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.provider.TitleRenderProvider;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.EntityTracker1_8;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.GameProfileStorage;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.InventoryTracker;
import com.viaversion.viarewind.protocol.v1_8to1_7_6_10.storage.PlayerSessionStorage;
import com.viaversion.viarewind.utils.ChatUtil;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.ClientWorld;
import com.viaversion.viaversion.api.minecraft.Environment;
import com.viaversion.viaversion.api.minecraft.entities.EntityType;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_8;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.protocol.packet.ClientboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandler;
import com.viaversion.viaversion.api.protocol.remapper.PacketHandlers;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ClientboundPackets1_8;
import com.viaversion.viaversion.protocols.v1_8to1_9.packet.ServerboundPackets1_8;
import com.viaversion.viaversion.util.ComponentUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;

public class PlayerPacketRewriter1_8 {
    public static void register(final Protocol1_8To1_7_6_10 protocol) {
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.CHAT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.COMPONENT);
                this.handler(wrapper -> {
                    byte position = (Byte)wrapper.read((Type)Types.BYTE);
                    if (position == 2) {
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_DEFAULT_SPAWN_POSITION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.INT_POSITION);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_HEALTH, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.VAR_INT, (Type)Types.SHORT);
                this.map((Type)Types.FLOAT);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.RESPAWN, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.UNSIGNED_BYTE);
                this.handler(wrapper -> {
                    if (ViaRewind.getConfig().isReplaceAdventureMode() && (Short)wrapper.get((Type)Types.UNSIGNED_BYTE, 1) == 2) {
                        wrapper.set((Type)Types.UNSIGNED_BYTE, 1, (Object)0);
                    }
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    tracker.setClientEntityGameMode(((Short)wrapper.get((Type)Types.UNSIGNED_BYTE, 1)).shortValue());
                    Environment dimension = Environment.getEnvironmentById((int)((Integer)wrapper.get((Type)Types.INT, 0)));
                    ClientWorld world = (ClientWorld)wrapper.user().get(ClientWorld.class);
                    if (world.getEnvironment() != dimension) {
                        world.setEnvironment(dimension.id());
                        tracker.clearEntities();
                        tracker.addEntity(tracker.clientEntityId(), (EntityType)EntityTypes1_8.EntityType.PLAYER);
                    }
                    wrapper.send(Protocol1_8To1_7_6_10.class);
                    wrapper.cancel();
                    if (tracker.getEntityData().isEmpty()) {
                        return;
                    }
                    PacketWrapper setEntityData = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_ENTITY_DATA, (UserConnection)wrapper.user());
                    setEntityData.write((Type)Types.VAR_INT, (Object)tracker.clientEntityId());
                    setEntityData.write(Types1_7_6_10.ENTITY_DATA_LIST, tracker.getEntityData());
                    setEntityData.send(Protocol1_8To1_7_6_10.class);
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.PLAYER_POSITION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.DOUBLE);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.handler(wrapper -> {
                    double x = (Double)wrapper.get((Type)Types.DOUBLE, 0);
                    double y = (Double)wrapper.get((Type)Types.DOUBLE, 1);
                    double z = (Double)wrapper.get((Type)Types.DOUBLE, 2);
                    float yaw = ((Float)wrapper.get((Type)Types.FLOAT, 0)).floatValue();
                    float pitch = ((Float)wrapper.get((Type)Types.FLOAT, 1)).floatValue();
                    PlayerSessionStorage playerSession = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
                    byte flags = (Byte)wrapper.read((Type)Types.BYTE);
                    if ((flags & 1) == 1) {
                        wrapper.set((Type)Types.DOUBLE, 0, (Object)(x + playerSession.getPosX()));
                    }
                    if ((flags & 2) == 2) {
                        y += playerSession.getPosY();
                    }
                    playerSession.receivedPosY = y;
                    wrapper.set((Type)Types.DOUBLE, 1, (Object)(y + (double)1.62f));
                    if ((flags & 4) == 4) {
                        wrapper.set((Type)Types.DOUBLE, 2, (Object)(z + playerSession.getPosZ()));
                    }
                    if ((flags & 8) == 8) {
                        wrapper.set((Type)Types.FLOAT, 0, (Object)Float.valueOf(yaw + playerSession.yaw));
                    }
                    if ((flags & 0x10) == 16) {
                        wrapper.set((Type)Types.FLOAT, 1, (Object)Float.valueOf(pitch + playerSession.pitch));
                    }
                    wrapper.write((Type)Types.BOOLEAN, (Object)playerSession.onGround);
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    if (tracker.spectatingClientEntityId != tracker.clientEntityId()) {
                        wrapper.cancel();
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_EXPERIENCE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.VAR_INT, (Type)Types.SHORT);
                this.map((Type)Types.VAR_INT, (Type)Types.SHORT);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.GAME_EVENT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.UNSIGNED_BYTE);
                this.map((Type)Types.FLOAT);
                this.handler(wrapper -> {
                    if ((Short)wrapper.get((Type)Types.UNSIGNED_BYTE, 0) != 3) {
                        return;
                    }
                    int gameMode = ((Float)wrapper.get((Type)Types.FLOAT, 0)).intValue();
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    if (gameMode == 3 || tracker.isSpectator()) {
                        UUID myId = wrapper.user().getProtocolInfo().getUuid();
                        Item[] equipment = new Item[4];
                        if (gameMode == 3) {
                            GameProfileStorage.GameProfile profile = ((GameProfileStorage)wrapper.user().get(GameProfileStorage.class)).get(myId);
                            equipment[3] = profile == null ? null : profile.getSkull();
                        } else {
                            for (int i = 0; i < equipment.length; ++i) {
                                equipment[i] = ((PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class)).getPlayerEquipment(myId, i);
                            }
                        }
                        for (int i = 0; i < equipment.length; ++i) {
                            PacketWrapper setSlot = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.CONTAINER_SET_SLOT, (UserConnection)wrapper.user());
                            setSlot.write((Type)Types.BYTE, (Object)0);
                            setSlot.write((Type)Types.SHORT, (Object)((short)(8 - i)));
                            setSlot.write(RewindTypes.COMPRESSED_NBT_ITEM, (Object)equipment[i]);
                            setSlot.scheduleSend(Protocol1_8To1_7_6_10.class);
                        }
                    }
                    if (gameMode == 2 && ViaRewind.getConfig().isReplaceAdventureMode()) {
                        gameMode = 0;
                        wrapper.set((Type)Types.FLOAT, 0, (Object)Float.valueOf(0.0f));
                    }
                    tracker.setClientEntityGameMode(gameMode);
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.OPEN_SIGN_EDITOR, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.BLOCK_POSITION1_8, RewindTypes.INT_POSITION);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.PLAYER_INFO, wrapper -> {
            wrapper.cancel();
            GameProfileStorage gameProfileStorage = (GameProfileStorage)wrapper.user().get(GameProfileStorage.class);
            int action = (Integer)wrapper.read((Type)Types.VAR_INT);
            int count = (Integer)wrapper.read((Type)Types.VAR_INT);
            for (int i = 0; i < count; ++i) {
                GameProfileStorage.GameProfile gameProfile;
                GameProfileStorage.GameProfile gameProfile2;
                UUID uuid = (UUID)wrapper.read(Types.UUID);
                if (action == 0) {
                    int ping;
                    String name = (String)wrapper.read(Types.STRING);
                    gameProfile2 = gameProfileStorage.get(uuid);
                    if (gameProfile2 == null) {
                        gameProfile2 = gameProfileStorage.put(uuid, name);
                    }
                    int propertyCount = (Integer)wrapper.read((Type)Types.VAR_INT);
                    while (propertyCount-- > 0) {
                        String propertyName = (String)wrapper.read(Types.STRING);
                        String propertyValue = (String)wrapper.read(Types.STRING);
                        String propertySignature = (String)wrapper.read(Types.OPTIONAL_STRING);
                        gameProfile2.properties.add(new GameProfileStorage.Property(propertyName, propertyValue, propertySignature));
                    }
                    int gamemode = (Integer)wrapper.read((Type)Types.VAR_INT);
                    gameProfile2.ping = ping = ((Integer)wrapper.read((Type)Types.VAR_INT)).intValue();
                    gameProfile2.gamemode = gamemode;
                    JsonElement displayName = (JsonElement)wrapper.read(Types.OPTIONAL_COMPONENT);
                    if (displayName != null) {
                        gameProfile2.setDisplayName(ChatUtil.jsonToLegacy(wrapper.user(), displayName));
                    }
                    PacketWrapper playerInfo = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.PLAYER_INFO, (UserConnection)wrapper.user());
                    playerInfo.write(Types.STRING, (Object)gameProfile2.getDisplayName());
                    playerInfo.write((Type)Types.BOOLEAN, (Object)true);
                    playerInfo.write((Type)Types.SHORT, (Object)((short)ping));
                    playerInfo.scheduleSend(Protocol1_8To1_7_6_10.class);
                    continue;
                }
                if (action == 1) {
                    int gamemode = (Integer)wrapper.read((Type)Types.VAR_INT);
                    gameProfile2 = gameProfileStorage.get(uuid);
                    if (gameProfile2 == null || gameProfile2.gamemode == gamemode) continue;
                    if (gamemode == 3 || gameProfile2.gamemode == 3) {
                        boolean isOwnPlayer;
                        EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                        int entityId = tracker.getPlayerEntityId(uuid);
                        boolean bl = isOwnPlayer = entityId == tracker.clientEntityId();
                        if (entityId != -1) {
                            Item[] equipment = new Item[isOwnPlayer ? 4 : 5];
                            if (gamemode == 3) {
                                equipment[isOwnPlayer ? 3 : 4] = gameProfile2.getSkull();
                            } else {
                                for (int j = 0; j < equipment.length; ++j) {
                                    equipment[j] = ((PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class)).getPlayerEquipment(uuid, j);
                                }
                            }
                            for (short slot = 0; slot < equipment.length; slot = (short)(slot + 1)) {
                                PacketWrapper setEquipment = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.SET_EQUIPPED_ITEM, (UserConnection)wrapper.user());
                                setEquipment.write((Type)Types.INT, (Object)entityId);
                                setEquipment.write((Type)Types.SHORT, (Object)slot);
                                setEquipment.write(RewindTypes.COMPRESSED_NBT_ITEM, (Object)equipment[slot]);
                                setEquipment.scheduleSend(Protocol1_8To1_7_6_10.class);
                            }
                        }
                    }
                    gameProfile2.gamemode = gamemode;
                    continue;
                }
                if (action == 2) {
                    int ping = (Integer)wrapper.read((Type)Types.VAR_INT);
                    gameProfile2 = gameProfileStorage.get(uuid);
                    if (gameProfile2 == null) continue;
                    PacketWrapper packet = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.PLAYER_INFO, (UserConnection)wrapper.user());
                    packet.write(Types.STRING, (Object)gameProfile2.getDisplayName());
                    packet.write((Type)Types.BOOLEAN, (Object)false);
                    packet.write((Type)Types.SHORT, (Object)((short)gameProfile2.ping));
                    packet.scheduleSend(Protocol1_8To1_7_6_10.class);
                    gameProfile2.ping = ping;
                    packet = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.PLAYER_INFO, (UserConnection)wrapper.user());
                    packet.write(Types.STRING, (Object)gameProfile2.getDisplayName());
                    packet.write((Type)Types.BOOLEAN, (Object)true);
                    packet.write((Type)Types.SHORT, (Object)((short)ping));
                    packet.scheduleSend(Protocol1_8To1_7_6_10.class);
                    continue;
                }
                if (action == 3) {
                    JsonElement displayNameComponent = (JsonElement)wrapper.read(Types.OPTIONAL_COMPONENT);
                    String displayName = displayNameComponent != null ? ChatUtil.jsonToLegacy(wrapper.user(), displayNameComponent) : null;
                    GameProfileStorage.GameProfile gameProfile3 = gameProfileStorage.get(uuid);
                    if (gameProfile3 == null || gameProfile3.displayName == null && displayName == null) continue;
                    PacketWrapper playerInfo = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.PLAYER_INFO, (UserConnection)wrapper.user());
                    playerInfo.write(Types.STRING, (Object)gameProfile3.getDisplayName());
                    playerInfo.write((Type)Types.BOOLEAN, (Object)false);
                    playerInfo.write((Type)Types.SHORT, (Object)((short)gameProfile3.ping));
                    playerInfo.scheduleSend(Protocol1_8To1_7_6_10.class);
                    if (gameProfile3.displayName == null && displayName != null || gameProfile3.displayName != null && displayName == null || !gameProfile3.displayName.equals(displayName)) {
                        gameProfile3.setDisplayName(displayName);
                    }
                    playerInfo = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.PLAYER_INFO, (UserConnection)wrapper.user());
                    playerInfo.write(Types.STRING, (Object)gameProfile3.getDisplayName());
                    playerInfo.write((Type)Types.BOOLEAN, (Object)true);
                    playerInfo.write((Type)Types.SHORT, (Object)((short)gameProfile3.ping));
                    playerInfo.scheduleSend(Protocol1_8To1_7_6_10.class);
                    continue;
                }
                if (action != 4 || (gameProfile = gameProfileStorage.remove(uuid)) == null) continue;
                PacketWrapper playerInfo = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.PLAYER_INFO, (UserConnection)wrapper.user());
                playerInfo.write(Types.STRING, (Object)gameProfile.getDisplayName());
                playerInfo.write((Type)Types.BOOLEAN, (Object)false);
                playerInfo.write((Type)Types.SHORT, (Object)((short)gameProfile.ping));
                playerInfo.scheduleSend(Protocol1_8To1_7_6_10.class);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.PLAYER_ABILITIES, wrapper -> {
            byte flags = (Byte)wrapper.passthrough((Type)Types.BYTE);
            float flySpeed = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            float walkSpeed = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            PlayerSessionStorage abilities = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
            abilities.invincible = (flags & 8) == 8;
            abilities.allowFly = (flags & 4) == 4;
            abilities.flying = (flags & 2) == 2;
            abilities.creative = (flags & 1) == 1;
            abilities.flySpeed = flySpeed;
            abilities.walkSpeed = walkSpeed;
            if (abilities.sprinting && abilities.flying) {
                wrapper.set((Type)Types.FLOAT, 0, (Object)Float.valueOf(abilities.flySpeed * 2.0f));
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.CUSTOM_PAYLOAD, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.handlerSoftFail(wrapper -> {
                    wrapper.cancel();
                    String channel = (String)wrapper.get(Types.STRING, 0);
                    if (channel.equals("MC|TrList")) {
                        wrapper.passthrough((Type)Types.INT);
                        int size = ((Short)wrapper.passthrough((Type)Types.UNSIGNED_BYTE)).shortValue();
                        for (int i = 0; i < size; ++i) {
                            Item item = protocol.getItemRewriter().handleItemToClient(wrapper.user(), (Item)wrapper.read(Types.ITEM1_8));
                            wrapper.write(RewindTypes.COMPRESSED_NBT_ITEM, (Object)item);
                            item = protocol.getItemRewriter().handleItemToClient(wrapper.user(), (Item)wrapper.read(Types.ITEM1_8));
                            wrapper.write(RewindTypes.COMPRESSED_NBT_ITEM, (Object)item);
                            boolean has3Items = (Boolean)wrapper.passthrough((Type)Types.BOOLEAN);
                            if (has3Items) {
                                item = protocol.getItemRewriter().handleItemToClient(wrapper.user(), (Item)wrapper.read(Types.ITEM1_8));
                                wrapper.write(RewindTypes.COMPRESSED_NBT_ITEM, (Object)item);
                            }
                            wrapper.passthrough((Type)Types.BOOLEAN);
                            wrapper.read((Type)Types.INT);
                            wrapper.read((Type)Types.INT);
                        }
                    } else if (channel.equals("MC|Brand")) {
                        wrapper.write(Types.REMAINING_BYTES, (Object)((String)wrapper.read(Types.STRING)).getBytes(StandardCharsets.UTF_8));
                    }
                    wrapper.setPacketType(null);
                    ByteBuf data = Unpooled.buffer();
                    wrapper.writeToBuffer(data);
                    PacketWrapper packet = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.CUSTOM_PAYLOAD, (ByteBuf)data, (UserConnection)wrapper.user());
                    packet.passthrough(Types.STRING);
                    if (data.readableBytes() <= Short.MAX_VALUE) {
                        packet.write((Type)Types.SHORT, (Object)((short)data.readableBytes()));
                        packet.send(Protocol1_8To1_7_6_10.class);
                    }
                });
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_CAMERA, null, wrapper -> {
            wrapper.cancel();
            int entityId = (Integer)wrapper.read((Type)Types.VAR_INT);
            EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
            if (tracker.spectatingClientEntityId != entityId) {
                tracker.setSpectating(entityId);
            }
        });
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.SET_TITLES, null, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.handler(wrapper -> {
                    wrapper.cancel();
                    int action = (Integer)wrapper.read((Type)Types.VAR_INT);
                    TitleRenderProvider provider = (TitleRenderProvider)Via.getManager().getProviders().get(TitleRenderProvider.class);
                    if (provider == null) {
                        return;
                    }
                    UUID uuid = wrapper.user().getProtocolInfo().getUuid();
                    switch (action) {
                        case 0: {
                            provider.setTitle(uuid, (String)wrapper.read(Types.STRING));
                            break;
                        }
                        case 1: {
                            provider.setSubTitle(uuid, (String)wrapper.read(Types.STRING));
                            break;
                        }
                        case 2: {
                            provider.setTimings(uuid, (Integer)wrapper.read((Type)Types.INT), (Integer)wrapper.read((Type)Types.INT), (Integer)wrapper.read((Type)Types.INT));
                            break;
                        }
                        case 3: {
                            provider.clear(uuid);
                            break;
                        }
                        case 4: {
                            provider.reset(uuid);
                        }
                    }
                });
            }
        });
        protocol.cancelClientbound((ClientboundPacketType)ClientboundPackets1_8.TAB_LIST);
        protocol.cancelClientbound((ClientboundPacketType)ClientboundPackets1_8.PLAYER_COMBAT);
        protocol.registerClientbound((ClientboundPacketType)ClientboundPackets1_8.RESOURCE_PACK, ClientboundPackets1_7_2_5.CUSTOM_PAYLOAD, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.create(Types.STRING, "MC|RPack");
                this.handler(wrapper -> {
                    ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
                    try {
                        Types.STRING.write(buf, (Object)((String)wrapper.read(Types.STRING)));
                        wrapper.write(Types.SHORT_BYTE_ARRAY, (Object)((byte[])Types.REMAINING_BYTES.read(buf)));
                    }
                    finally {
                        buf.release();
                    }
                });
                this.read(Types.STRING);
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.CHAT, wrapper -> {
            String message = (String)wrapper.passthrough(Types.STRING);
            EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
            if (tracker.isSpectator() && message.toLowerCase().startsWith("/stp ")) {
                String username = message.split(" ")[1];
                GameProfileStorage storage = (GameProfileStorage)wrapper.user().get(GameProfileStorage.class);
                GameProfileStorage.GameProfile profile = storage.get(username, true);
                if (profile != null && profile.uuid != null) {
                    wrapper.cancel();
                    PacketWrapper teleport = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.TELEPORT_ENTITY, (UserConnection)wrapper.user());
                    teleport.write(Types.UUID, (Object)profile.uuid);
                    teleport.send(Protocol1_8To1_7_6_10.class);
                }
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.INTERACT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT, (Type)Types.VAR_INT);
                this.map((Type)Types.BYTE, (Type)Types.VAR_INT);
                this.handler(wrapper -> {
                    int mode = (Integer)wrapper.get((Type)Types.VAR_INT, 1);
                    if (mode != 0) {
                        return;
                    }
                    int entityId = (Integer)wrapper.get((Type)Types.VAR_INT, 0);
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    PlayerSessionStorage position = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
                    if (!tracker.getHolograms().containsKey(entityId)) {
                        return;
                    }
                    AABB boundingBox = ((VirtualHologramEntity)tracker.getHolograms().get(entityId)).getBoundingBox();
                    Vector3d pos = new Vector3d(position.getPosX(), position.getPosY() + 1.8, position.getPosZ());
                    double yaw = Math.toRadians(position.yaw);
                    double pitch = Math.toRadians(position.pitch);
                    Vector3d dir = new Vector3d(-Math.cos(pitch) * Math.sin(yaw), -Math.sin(pitch), Math.cos(pitch) * Math.cos(yaw));
                    Ray3d ray = new Ray3d(pos, dir);
                    Vector3d intersection = RayTracing.trace(ray, boundingBox, 5.0);
                    if (intersection == null) {
                        return;
                    }
                    intersection.substract(boundingBox.getMin());
                    wrapper.set((Type)Types.VAR_INT, 1, (Object)2);
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf((float)intersection.getX()));
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf((float)intersection.getY()));
                    wrapper.write((Type)Types.FLOAT, (Object)Float.valueOf((float)intersection.getZ()));
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.MOVE_PLAYER_STATUS_ONLY, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.BOOLEAN);
                this.handler(wrapper -> {
                    ((PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class)).onGround = (Boolean)wrapper.get((Type)Types.BOOLEAN, 0);
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.MOVE_PLAYER_POS, wrapper -> {
            double x = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            double y = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.read((Type)Types.DOUBLE);
            double z = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            PlayerSessionStorage storage = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
            storage.onGround = (Boolean)wrapper.passthrough((Type)Types.BOOLEAN);
            storage.setPos(x, y, z);
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.MOVE_PLAYER_ROT, wrapper -> {
            PlayerSessionStorage storage = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
            storage.yaw = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            storage.pitch = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            storage.onGround = (Boolean)wrapper.passthrough((Type)Types.BOOLEAN);
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.MOVE_PLAYER_POS_ROT, wrapper -> {
            double x = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            double y = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            wrapper.read((Type)Types.DOUBLE);
            double z = (Double)wrapper.passthrough((Type)Types.DOUBLE);
            PlayerSessionStorage storage = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
            storage.setPos(x, y, z);
            storage.yaw = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            storage.pitch = ((Float)wrapper.passthrough((Type)Types.FLOAT)).floatValue();
            storage.onGround = (Boolean)wrapper.passthrough((Type)Types.BOOLEAN);
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.PLAYER_ACTION, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.map((Type)Types.VAR_INT);
                this.map(RewindTypes.U_BYTE_POSITION, Types.BLOCK_POSITION1_8);
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.USE_ITEM_ON, (PacketHandler)new PacketHandlers(){

            protected void register() {
                this.map(RewindTypes.U_BYTE_POSITION, Types.BLOCK_POSITION1_8);
                this.map((Type)Types.BYTE);
                this.map(RewindTypes.COMPRESSED_NBT_ITEM, Types.ITEM1_8);
                this.handler(wrapper -> protocol.getItemRewriter().handleItemToServer(wrapper.user(), (Item)wrapper.get(Types.ITEM1_8, 0)));
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.SWING, wrapper -> {
            int entityId = (Integer)wrapper.read((Type)Types.INT);
            int animation = ((Byte)wrapper.read((Type)Types.BYTE)).byteValue();
            if (animation == 1) {
                return;
            }
            wrapper.cancel();
            switch (animation) {
                case 104: {
                    animation = 0;
                    break;
                }
                case 105: {
                    animation = 1;
                    break;
                }
                case 3: {
                    animation = 2;
                    break;
                }
                default: {
                    return;
                }
            }
            PacketWrapper animate = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.ANIMATE, (UserConnection)wrapper.user());
            animate.write((Type)Types.VAR_INT, (Object)entityId);
            animate.write((Type)Types.VAR_INT, (Object)animation);
            animate.write((Type)Types.VAR_INT, (Object)0);
            animate.send(Protocol1_8To1_7_6_10.class);
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.PLAYER_COMMAND, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.INT, (Type)Types.VAR_INT);
                this.handler(wrapper -> wrapper.write((Type)Types.VAR_INT, (Object)((Byte)wrapper.read((Type)Types.BYTE) - 1)));
                this.map((Type)Types.INT, (Type)Types.VAR_INT);
                this.handler(wrapper -> {
                    int action = (Integer)wrapper.get((Type)Types.VAR_INT, 1);
                    if (action == 3 || action == 4) {
                        PlayerSessionStorage storage = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
                        storage.sprinting = action == 3;
                        PacketWrapper abilities = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.PLAYER_ABILITIES, (UserConnection)wrapper.user());
                        abilities.write((Type)Types.BYTE, (Object)storage.combineAbilities());
                        abilities.write((Type)Types.FLOAT, (Object)Float.valueOf(storage.sprinting ? storage.flySpeed * 2.0f : storage.flySpeed));
                        abilities.write((Type)Types.FLOAT, (Object)Float.valueOf(storage.walkSpeed));
                        abilities.scheduleSend(Protocol1_8To1_7_6_10.class);
                    }
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.PLAYER_INPUT, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.handler(wrapper -> {
                    boolean jump = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                    boolean unmount = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                    short flags = 0;
                    if (jump) {
                        flags = (short)(flags + 1);
                    }
                    if (unmount) {
                        flags = (short)(flags + 2);
                    }
                    wrapper.write((Type)Types.UNSIGNED_BYTE, (Object)flags);
                    if (!unmount) {
                        return;
                    }
                    EntityTracker1_8 tracker = (EntityTracker1_8)wrapper.user().getEntityTracker(Protocol1_8To1_7_6_10.class);
                    if (tracker.spectatingClientEntityId != tracker.clientEntityId()) {
                        PacketWrapper sneakPacket = PacketWrapper.create((PacketType)ServerboundPackets1_8.PLAYER_COMMAND, (UserConnection)wrapper.user());
                        sneakPacket.write((Type)Types.VAR_INT, (Object)tracker.clientEntityId());
                        sneakPacket.write((Type)Types.VAR_INT, (Object)0);
                        sneakPacket.write((Type)Types.VAR_INT, (Object)0);
                        sneakPacket.scheduleSendToServer(Protocol1_8To1_7_6_10.class);
                    }
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.SIGN_UPDATE, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(RewindTypes.SHORT_POSITION, Types.BLOCK_POSITION1_8);
                this.handler(wrapper -> {
                    for (int i = 0; i < 4; ++i) {
                        String line = (String)wrapper.read(Types.STRING);
                        wrapper.write(Types.COMPONENT, (Object)ComponentUtil.legacyToJson((String)line));
                    }
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.PLAYER_ABILITIES, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map((Type)Types.BYTE);
                this.map((Type)Types.FLOAT);
                this.map((Type)Types.FLOAT);
                this.handler(wrapper -> {
                    PlayerSessionStorage storage = (PlayerSessionStorage)wrapper.user().get(PlayerSessionStorage.class);
                    if (storage.allowFly) {
                        byte flags = (Byte)wrapper.get((Type)Types.BYTE, 0);
                        storage.flying = (flags & 2) == 2;
                    }
                    wrapper.set((Type)Types.FLOAT, 0, (Object)Float.valueOf(storage.flySpeed));
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.COMMAND_SUGGESTION, wrapper -> {
            String message = (String)wrapper.passthrough(Types.STRING);
            wrapper.write(Types.OPTIONAL_POSITION1_8, null);
            if (message.toLowerCase().startsWith("/stp ")) {
                wrapper.cancel();
                String[] args = message.split(" ");
                if (args.length <= 2) {
                    String prefix = args.length == 1 ? "" : args[1];
                    GameProfileStorage storage = (GameProfileStorage)wrapper.user().get(GameProfileStorage.class);
                    List<GameProfileStorage.GameProfile> profiles = storage.getAllWithPrefix(prefix, true);
                    PacketWrapper commandSuggestions = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.COMMAND_SUGGESTIONS, (UserConnection)wrapper.user());
                    commandSuggestions.write((Type)Types.VAR_INT, (Object)profiles.size());
                    for (GameProfileStorage.GameProfile profile : profiles) {
                        commandSuggestions.write(Types.STRING, (Object)profile.name);
                    }
                    commandSuggestions.scheduleSend(Protocol1_8To1_7_6_10.class);
                }
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.CLIENT_INFORMATION, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BYTE);
                this.map((Type)Types.BOOLEAN);
                this.read((Type)Types.BYTE);
                this.handler(wrapper -> {
                    boolean showCape = (Boolean)wrapper.read((Type)Types.BOOLEAN);
                    wrapper.write((Type)Types.UNSIGNED_BYTE, (Object)((short)(showCape ? 127 : 126)));
                });
            }
        });
        protocol.registerServerbound(ServerboundPackets1_7_2_5.CUSTOM_PAYLOAD, (PacketHandler)new PacketHandlers(){

            public void register() {
                this.map(Types.STRING);
                this.read((Type)Types.SHORT);
                this.handler(wrapper -> {
                    String channel;
                    switch (channel = (String)wrapper.get(Types.STRING, 0)) {
                        case "MC|TrSel": {
                            wrapper.passthrough((Type)Types.INT);
                            wrapper.read(Types.REMAINING_BYTES);
                            break;
                        }
                        case "MC|ItemName": {
                            byte[] data = (byte[])wrapper.read(Types.REMAINING_BYTES);
                            wrapper.write(Types.STRING, (Object)new String(data, StandardCharsets.UTF_8));
                            InventoryTracker tracker = (InventoryTracker)wrapper.user().get(InventoryTracker.class);
                            PacketWrapper updateCost = PacketWrapper.create((PacketType)ClientboundPackets1_7_2_5.CONTAINER_SET_DATA, (UserConnection)wrapper.user());
                            updateCost.write((Type)Types.UNSIGNED_BYTE, (Object)tracker.anvilId);
                            updateCost.write((Type)Types.SHORT, (Object)0);
                            updateCost.write((Type)Types.SHORT, (Object)tracker.levelCost);
                            updateCost.send(Protocol1_8To1_7_6_10.class);
                            break;
                        }
                        case "MC|BEdit": 
                        case "MC|BSign": {
                            Item book = (Item)wrapper.read(RewindTypes.COMPRESSED_NBT_ITEM);
                            CompoundTag tag = book.tag();
                            if (tag != null && tag.contains("pages")) {
                                ListTag pages = tag.getListTag("pages", StringTag.class);
                                for (int i = 0; i < pages.size(); ++i) {
                                    StringTag page = (StringTag)pages.get(i);
                                    String value = page.getValue();
                                    value = ComponentUtil.legacyToJsonString((String)value);
                                    page.setValue(value);
                                }
                            }
                            wrapper.write(Types.ITEM1_8, (Object)book);
                            break;
                        }
                        case "MC|Brand": {
                            wrapper.write(Types.STRING, (Object)new String((byte[])wrapper.read(Types.REMAINING_BYTES), StandardCharsets.UTF_8));
                        }
                    }
                });
            }
        });
    }
}

