/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.classresources.customheads.methods;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;

public class CustomHeadPlayerProfile {
    public HashMap<String, ItemStack> savedCustomHeads = new HashMap();

    public ItemStack getCustomHead(String base64Texture) {
        if (this.savedCustomHeads.containsKey(base64Texture)) {
            return this.savedCustomHeads.get(base64Texture);
        }
        Iterator<Map.Entry<String, ItemStack>> iterator = this.savedCustomHeads.entrySet().iterator();
        while (this.savedCustomHeads.size() > 2000 && iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        UUID uuid = UUID.randomUUID();
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)uuid);
        String decodedTexture = this.extractSkinUrlFromBase64(base64Texture);
        PlayerTextures textures = profile.getTextures();
        try {
            textures.setSkin(new URL(decodedTexture));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        profile.setTextures(textures);
        skullMeta.setOwnerProfile(profile);
        skull.setItemMeta((ItemMeta)skullMeta);
        this.savedCustomHeads.put(base64Texture, skull);
        return skull;
    }

    public ItemStack getPlayerHead(String playerName) {
        if (this.savedCustomHeads.containsKey(playerName)) {
            return this.savedCustomHeads.get(playerName);
        }
        Iterator<Map.Entry<String, ItemStack>> iterator = this.savedCustomHeads.entrySet().iterator();
        while (this.savedCustomHeads.size() > 2000 && iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD, 1);
        SkullMeta skullMeta = (SkullMeta)skull.getItemMeta();
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
        UUID playerUUID = offlinePlayer.getUniqueId();
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)playerUUID);
        skullMeta.setOwnerProfile(profile);
        skull.setItemMeta((ItemMeta)skullMeta);
        this.savedCustomHeads.put(playerName, skull);
        return skull;
    }

    private String extractSkinUrlFromBase64(String base64Texture) {
        byte[] decodedBytes = Base64.getDecoder().decode(base64Texture);
        String decodedString = new String(decodedBytes);
        JsonObject jsonObject = JsonParser.parseString((String)decodedString).getAsJsonObject();
        JsonObject textures = jsonObject.getAsJsonObject("textures");
        JsonObject skin = textures.getAsJsonObject("SKIN");
        return skin.has("url") ? skin.get("url").getAsString() : null;
    }
}

