/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels.panelblocks;

import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;

public class PanelBlockOnClick
implements Listener {
    CommandPanels plugin;

    public PanelBlockOnClick(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onInteract(PlayerInteractEvent e) {
        boolean isPanelBlock;
        if (e.getAction() == Action.RIGHT_CLICK_BLOCK && e.getClickedBlock() != null && (isPanelBlock = this.blockClickEventTrigger(e.getClickedBlock().getLocation(), e.getPlayer(), true))) {
            this.blockClickEventTrigger(e.getClickedBlock().getLocation(), e.getPlayer(), false);
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onInteractEntity(PlayerInteractEntityEvent e) {
        boolean isPanelBlock = this.blockClickEventTrigger(e.getRightClicked().getLocation().getBlock().getLocation(), e.getPlayer(), true);
        if (isPanelBlock && !e.getPlayer().isSneaking()) {
            this.blockClickEventTrigger(e.getRightClicked().getLocation().getBlock().getLocation(), e.getPlayer(), false);
            e.setCancelled(true);
        }
    }

    public boolean blockClickEventTrigger(Location location, Player p, boolean isVoid) {
        if (Objects.requireNonNull(this.plugin.config.getString("config.panel-blocks")).equalsIgnoreCase("false")) {
            return false;
        }
        if (!this.plugin.blockConfig.contains("blocks")) {
            return false;
        }
        if (this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return false;
        }
        for (String configLocation : Objects.requireNonNull(this.plugin.blockConfig.getConfigurationSection("blocks")).getKeys(false)) {
            String[] loc = configLocation.split("_");
            Location tempLocation = new Location(this.plugin.getServer().getWorld(loc[0].replaceAll("%dash%", "_")), Double.parseDouble(loc[1]), Double.parseDouble(loc[2]), Double.parseDouble(loc[3]));
            if (!tempLocation.equals((Object)location)) continue;
            if (this.plugin.blockConfig.contains("blocks." + configLocation + ".commands")) {
                if (!isVoid) {
                    for (String command : this.plugin.blockConfig.getStringList("blocks." + configLocation + ".commands")) {
                        this.plugin.commandRunner.runCommand(null, PanelPosition.Top, p, command);
                    }
                }
                return true;
            }
            if (!isVoid) {
                String command = "open= " + this.plugin.blockConfig.getString("blocks." + configLocation + ".panel");
                this.plugin.commandRunner.runCommand(null, PanelPosition.Top, p, command);
            }
            return true;
        }
        return false;
    }
}

