/*
 * Decompiled with CFR 0.152.
 */
package me.rockyhawk.commandpanels;

import java.util.List;
import java.util.Objects;
import me.rockyhawk.commandpanels.CommandPanels;
import me.rockyhawk.commandpanels.api.Panel;
import me.rockyhawk.commandpanels.interactives.input.PlayerInput;
import me.rockyhawk.commandpanels.openpanelsmanager.PanelPosition;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;

public class Utils
implements Listener {
    CommandPanels plugin;

    public Utils(CommandPanels pl) {
        this.plugin = pl;
    }

    @EventHandler
    public void onItemDrag(InventoryDragEvent e) {
        Player p = (Player)e.getWhoClicked();
        if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) {
            return;
        }
        if (e.getInventory().getType() != InventoryType.PLAYER) {
            e.setCancelled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler
    public void onPanelClick(InventoryClickEvent e) {
        Player p = (Player)e.getWhoClicked();
        int clickedSlot = e.getSlot();
        if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Top)) return;
        if (e.getClick() == ClickType.DOUBLE_CLICK) {
            return;
        }
        Panel panel = this.plugin.openPanels.getOpenPanel(p.getName(), PanelPosition.Top);
        if (e.getSlotType() == InventoryType.SlotType.OUTSIDE) {
            if (!panel.getConfig().contains("outside-commands")) return;
            try {
                this.plugin.commandRunner.runCommands(panel, PanelPosition.Top, p, panel.getConfig().getStringList("outside-commands"), e.getClick());
                return;
            }
            catch (Exception s) {
                this.plugin.debug(s, p);
            }
            return;
        }
        PanelPosition position = PanelPosition.Top;
        if (e.getClickedInventory().getType() == InventoryType.PLAYER) {
            if (e.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
                e.setCancelled(true);
                return;
            }
            if (e.getSlotType() == InventoryType.SlotType.CONTAINER) {
                if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Middle)) {
                    e.setCancelled(this.itemsUnmovable(panel));
                    return;
                }
                position = PanelPosition.Middle;
                clickedSlot -= 9;
            } else {
                if (!this.plugin.openPanels.hasPanelOpen(p.getName(), PanelPosition.Bottom)) {
                    e.setCancelled(this.itemsUnmovable(panel));
                    return;
                }
                position = PanelPosition.Bottom;
                e.setCancelled(true);
            }
        }
        panel = this.plugin.openPanels.getOpenPanel(p.getName(), position);
        String foundSlot = null;
        for (String item : Objects.requireNonNull(panel.getConfig().getConfigurationSection("item")).getKeys(false)) {
            String slot = this.plugin.tex.placeholdersNoColour(panel, position, p, item);
            if (!slot.equals(Integer.toString(clickedSlot))) continue;
            foundSlot = item;
            break;
        }
        if (foundSlot == null) {
            e.setCancelled(true);
            return;
        }
        String section = this.plugin.has.hasSection(panel, position, panel.getConfig().getConfigurationSection("item." + foundSlot), p);
        if (panel.getConfig().contains("item." + foundSlot + section + ".itemType") && panel.getConfig().getStringList("item." + foundSlot + section + ".itemType").contains("placeable")) {
            e.setCancelled(false);
            return;
        }
        e.setCancelled(true);
        p.updateInventory();
        if (panel.getConfig().contains("item." + foundSlot + section + ".player-input")) {
            this.plugin.inputUtils.playerInput.put(p, new PlayerInput(panel, panel.getConfig().getStringList("item." + foundSlot + section + ".player-input"), e.getClick()));
            this.plugin.inputUtils.sendMessage(panel, position, p);
        }
        if (!panel.getConfig().contains("item." + foundSlot + section + ".commands")) return;
        List commands = panel.getConfig().getStringList("item." + foundSlot + section + ".commands");
        if (commands.isEmpty()) return;
        for (int i = 0; commands.size() > i; ++i) {
            try {
                commands.set(i, ((String)commands.get(i)).replaceAll("%cp-clicked%", e.getCurrentItem().getType().toString()));
                continue;
            }
            catch (Exception mate) {
                commands.set(i, ((String)commands.get(i)).replaceAll("%cp-clicked%", "AIR"));
            }
        }
        if (panel.getConfig().contains("item." + foundSlot + section + ".multi-paywall")) {
            this.plugin.commandRunner.runMultiPaywall(panel, position, p, panel.getConfig().getStringList("item." + foundSlot + section + ".multi-paywall"), commands, e.getClick());
            return;
        }
        this.plugin.commandRunner.runCommands(panel, position, p, commands, e.getClick());
    }

    private boolean itemsUnmovable(Panel panel) {
        if (panel.getConfig().isSet("panelType")) {
            return panel.getConfig().getStringList("panelType").contains("unmovable");
        }
        return false;
    }
}

