/*
 * Decompiled with CFR 0.152.
 */
package me.clip.placeholderapi.updatechecker;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.util.Msg;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;

public class UpdateChecker
implements Listener {
    private final int RESOURCE_ID = 6245;
    private final PlaceholderAPIPlugin plugin;
    private final String pluginVersion;
    private String spigotVersion;
    private boolean updateAvailable;

    public UpdateChecker(PlaceholderAPIPlugin i) {
        this.plugin = i;
        this.pluginVersion = i.getDescription().getVersion();
    }

    public boolean hasUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getSpigotVersion() {
        return this.spigotVersion;
    }

    public void fetch() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpsURLConnection con = (HttpsURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=6245").openConnection();
                con.setRequestMethod("GET");
                this.spigotVersion = new BufferedReader(new InputStreamReader(con.getInputStream())).readLine();
            }
            catch (Exception ex) {
                this.plugin.getLogger().info("Failed to check for updates on spigot.");
                return;
            }
            if (this.spigotVersion == null || this.spigotVersion.isEmpty()) {
                return;
            }
            this.updateAvailable = this.spigotIsNewer();
            if (!this.updateAvailable) {
                return;
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                this.plugin.getLogger().info("An update for PlaceholderAPI (v" + this.getSpigotVersion() + ") is available at:");
                this.plugin.getLogger().info("https://www.spigotmc.org/resources/placeholderapi.6245/");
                Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
            });
        });
    }

    private boolean spigotIsNewer() {
        int[] spV;
        if (this.spigotVersion == null || this.spigotVersion.isEmpty()) {
            return false;
        }
        int[] plV = this.toReadable(this.pluginVersion);
        if (plV[0] < (spV = this.toReadable(this.spigotVersion))[0]) {
            return true;
        }
        if (plV[1] < spV[1]) {
            return true;
        }
        return plV[2] < spV[2];
    }

    private int[] toReadable(String version) {
        if (version.contains("-DEV")) {
            version = version.split("-DEV")[0];
        }
        return Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent e) {
        if (e.getPlayer().hasPermission("placeholderapi.updatenotify")) {
            Msg.msg((CommandSender)e.getPlayer(), "&bAn update for &fPlaceholder&7API &e(&fPlaceholder&7API &fv" + this.getSpigotVersion() + "&e)", "&bis available at &ehttps://www.spigotmc.org/resources/placeholderapi.6245/");
        }
    }
}

