/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import de.bananaco.permissions.Permissions;
import de.bananaco.permissions.interfaces.PermissionSet;
import de.bananaco.permissions.worlds.HasPermission;
import de.bananaco.permissions.worlds.WorldPermissionsManager;
import java.util.List;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Permission_bPermissions
extends Permission {
    private final String name = "bPermissions";
    private WorldPermissionsManager perms;

    public Permission_bPermissions(Plugin plugin) {
        Plugin p;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(), plugin);
        if (this.perms == null && (p = plugin.getServer().getPluginManager().getPlugin("bPermissions")) != null) {
            this.perms = Permissions.getWorldPermissionsManager();
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "bPermissions"));
        }
    }

    @Override
    public String getName() {
        return "bPermissions";
    }

    @Override
    public boolean isEnabled() {
        return this.perms != null;
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        return HasPermission.has((String)player, (String)world, (String)permission);
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        set.addPlayerNode(permission, player);
        return true;
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        set.removePlayerNode(permission, player);
        return true;
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        if (set.getGroupNodes(group) == null) {
            return false;
        }
        return set.getGroupNodes(group).contains(permission);
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        if (set.getGroupNodes(group) == null) {
            return false;
        }
        set.addNode(permission, group);
        return true;
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        if (set.getGroupNodes(group) == null) {
            return false;
        }
        set.removeNode(permission, group);
        return true;
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        if (set.getGroups(player) == null) {
            return false;
        }
        return set.getGroups(player).contains(group);
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        if (set.getGroupNodes(group) == null) {
            return false;
        }
        set.addGroup(player, group);
        return true;
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        if (world == null) {
            return false;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return false;
        }
        set.removeGroup(player, group);
        return true;
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        if (world == null) {
            return null;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return null;
        }
        List groups = set.getGroups(player);
        return groups == null ? null : groups.toArray(new String[0]);
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        if (world == null) {
            return null;
        }
        PermissionSet set = this.perms.getPermissionSet(world);
        if (set == null) {
            return null;
        }
        List groups = set.getGroups(player);
        if (groups == null || groups.isEmpty()) {
            return null;
        }
        return (String)groups.get(0);
    }

    @Override
    public String[] getGroups() {
        throw new UnsupportedOperationException("bPermissions does not support server-wide groups");
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean hasGroupSupport() {
        return true;
    }

    public class PermissionServerListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin p;
            if (Permission_bPermissions.this.perms == null && (p = event.getPlugin()).getDescription().getName().equals("bPermissions") && p.isEnabled()) {
                Permission_bPermissions.this.perms = Permissions.getWorldPermissionsManager();
                log.info(String.format("[%s][Permission] %s hooked.", Permission_bPermissions.this.plugin.getDescription().getName(), "bPermissions"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (Permission_bPermissions.this.perms != null && event.getPlugin().getDescription().getName().equals("bPermissions")) {
                Permission_bPermissions.this.perms = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_bPermissions.this.plugin.getDescription().getName(), "bPermissions"));
            }
        }
    }
}

