/*
 * Decompiled with CFR 0.152.
 */
package ce.ajneb97.managers;

import ce.ajneb97.ConditionalEvents;
import ce.ajneb97.model.player.PlayerData;
import java.util.ArrayList;
import org.bukkit.entity.Player;

public class PlayerManager {
    private ConditionalEvents plugin;
    private ArrayList<PlayerData> playerData;

    public PlayerManager(ConditionalEvents plugin) {
        this.plugin = plugin;
        this.playerData = new ArrayList();
    }

    public ArrayList<PlayerData> getPlayerData() {
        return this.playerData;
    }

    public void setPlayerData(ArrayList<PlayerData> playerData) {
        this.playerData = playerData;
    }

    public PlayerData getPlayerData(Player player) {
        for (PlayerData p : this.playerData) {
            if (!p.getUuid().equals(player.getUniqueId().toString())) continue;
            return p;
        }
        return null;
    }

    public PlayerData getPlayerDataByName(String playerName) {
        for (PlayerData p : this.playerData) {
            if (!p.getName().equals(playerName)) continue;
            return p;
        }
        return null;
    }

    private PlayerData createPlayerData(Player player) {
        PlayerData p = this.getPlayerData(player);
        if (p == null) {
            p = new PlayerData(player.getUniqueId().toString(), player.getName());
            p.setModified(true);
            this.playerData.add(p);
        }
        return p;
    }

    public void setEventCooldown(String eventName, Player player) {
        PlayerData p = this.createPlayerData(player);
        p.setCooldown(eventName, System.currentTimeMillis());
        p.setModified(true);
    }

    public long getEventCooldown(String eventName, Player player) {
        PlayerData p = this.getPlayerData(player);
        if (p == null) {
            return 0L;
        }
        return p.getCooldown(eventName);
    }

    public void setEventOneTime(String eventName, Player player) {
        PlayerData p = this.createPlayerData(player);
        p.setOneTime(eventName, true);
        p.setModified(true);
    }

    public boolean getEventOneTime(String eventName, Player player) {
        PlayerData p = this.getPlayerData(player);
        if (p == null) {
            return false;
        }
        return p.isEventOneTime(eventName);
    }

    public void resetEventDataForPlayers(String eventName) {
        for (PlayerData p : this.playerData) {
            p.resetCooldown(eventName);
            p.setOneTime(eventName, false);
            p.setModified(true);
        }
    }

    public void resetAllDataForPlayers() {
        for (PlayerData p : this.playerData) {
            p.resetAll();
            p.setModified(true);
        }
    }
}

