/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.service.impl;

import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jiucai.appframework.base.service.impl.AbstractBaseService;
import org.jiucai.appframework.base.util.ConfigUtil;
import org.jiucai.appframework.base.web.render.JsonRender;
import org.jiucai.appframework.base.web.render.XmlRender;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class DefaultAppBaseService
extends AbstractBaseService {
    protected static String encoding = "UTF-8";
    protected static Configuration config = ConfigUtil.addConfig("config");
    @Autowired
    private XmlRender xmlRender;
    @Autowired
    private JsonRender jsonRender;

    public static Configuration getConfig() {
        return config;
    }

    @Override
    public String getContentType() {
        return this.getJsonRender().getContentType();
    }

    public JsonRender getJsonRender() {
        this.jsonRender.setEncoding(encoding);
        return this.jsonRender;
    }

    public XmlRender getXmlRender() {
        this.xmlRender.setEncoding(encoding);
        return this.xmlRender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void output(HttpServletResponse response, String msg, String contentType) {
        PrintWriter out = null;
        try {
            response.setHeader("Content-Type", contentType);
            response.setHeader("Pragma", "no-cache");
            response.addHeader("Cache-Control", "must-revalidate");
            response.addHeader("Cache-Control", "no-cache");
            response.addHeader("Cache-Control", "no-store");
            response.setDateHeader("Expires", 0L);
            out = response.getWriter();
            if (null != out) {
                if (null == msg) {
                    msg = "";
                }
                out.write(msg);
            }
        }
        catch (Exception e) {
            this.log.error("output failed: " + ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    protected String getJsonMsg(Boolean isSuccess, String msg) {
        StringBuffer result = new StringBuffer("");
        if (isSuccess.booleanValue()) {
            if (StringUtils.isBlank((String)msg)) {
                msg = "ok";
            }
            result.append("{\"success\":\"").append(msg).append("\"}");
        } else {
            if (StringUtils.isBlank((String)msg)) {
                msg = "failed";
            }
            result.append("{\"error\":\"").append(msg).append("\"}");
        }
        return result.toString();
    }

    protected String getXmlMsg(Boolean isSuccess, String msg) {
        StringBuffer result = new StringBuffer("");
        if (isSuccess.booleanValue()) {
            if (StringUtils.isBlank((String)msg)) {
                msg = "ok";
            }
            result.append("<chart><success>").append(msg).append("</success></chart>");
        } else {
            if (StringUtils.isBlank((String)msg)) {
                msg = "failed";
            }
            result.append("<chart><error>").append(msg).append("</error></chart>");
        }
        return result.toString();
    }

    static {
        config = ConfigUtil.addConfig("mail");
    }
}

