/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.base.util;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    public static final String CHARSET_UTF8 = "UTF-8";
    protected static Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);
    private static ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code >= 500) {
                return String.valueOf(code);
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Charset charset = ContentType.getOrDefault((HttpEntity)entity).getCharset();
                if (null != charset) {
                    return new String(EntityUtils.toByteArray((HttpEntity)entity), charset);
                }
                return new String(EntityUtils.toByteArray((HttpEntity)entity));
            }
            return null;
        }
    };

    public static void abortConnection(HttpUriRequest hrb, CloseableHttpClient httpclient) {
        if (hrb != null) {
            hrb.abort();
        }
        if (httpclient != null) {
            try {
                httpclient.close();
            }
            catch (IOException e) {
                logger.error("failed to close httpclient", (Throwable)e);
            }
        }
    }

    public static String get(String url) {
        return HttpClientUtil.get(url, null, CHARSET_UTF8);
    }

    public static String get(String url, Map<String, String> params) {
        return HttpClientUtil.get(url, params, CHARSET_UTF8);
    }

    public static String get(String url, Map<String, String> params, String charset) {
        return HttpClientUtil.get(url, params, charset, HttpClientUtil.getHttpClient(charset));
    }

    public static String get(String url, Map<String, String> params, String charset, CloseableHttpClient client) {
        if (url == null || StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        List<NameValuePair> qparams = HttpClientUtil.getParamsList(params);
        if (qparams != null && qparams.size() > 0) {
            charset = charset == null ? CHARSET_UTF8 : charset;
            String formatParams = URLEncodedUtils.format(qparams, (String)charset);
            url = url.indexOf("?") < 0 ? url + "?" + formatParams : url.substring(0, url.indexOf("?") + 1) + formatParams;
        }
        HttpGet hg = new HttpGet(url);
        String responseStr = null;
        try {
            responseStr = (String)client.execute((HttpUriRequest)hg, responseHandler);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("\u5ba2\u6237\u7aef\u8fde\u63a5\u534f\u8bae\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u64cd\u4f5c\u5f02\u5e38", e);
        }
        finally {
            HttpClientUtil.abortConnection((HttpUriRequest)hg, client);
        }
        return responseStr;
    }

    public static HttpClientConnectionManager getConnectionManager() {
        SSLConnectionSocketFactory sslsf = null;
        RegistryBuilder registryBuilder = RegistryBuilder.create();
        PlainConnectionSocketFactory plainsf = PlainConnectionSocketFactory.getSocketFactory();
        registryBuilder.register("http", (Object)plainsf);
        try {
            SSLContext sslcontext = SSLContexts.custom().loadTrustMaterial(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            NoopHostnameVerifier allowAllHostnameVerifier = NoopHostnameVerifier.INSTANCE;
            sslsf = new SSLConnectionSocketFactory(sslcontext, (HostnameVerifier)allowAllHostnameVerifier);
            registryBuilder.register("https", (Object)sslsf);
        }
        catch (Throwable e) {
            logger.error("https ssl init failed", e);
        }
        Registry r = registryBuilder.build();
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(r);
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(100);
        return connManager;
    }

    public static CloseableHttpClient getHttpClient(String charset) {
        return HttpClientUtil.getHttpClientBuilder(charset, null, 0).build();
    }

    public static HttpClientBuilder getHttpClientBuilder(String charset, String proxyIp, int proxyPort) {
        HttpClientBuilder builder = HttpClients.custom();
        Charset chartset = charset == null ? Charset.forName(CHARSET_UTF8) : Charset.forName(charset);
        ConnectionConfig.Builder connBuilder = ConnectionConfig.custom().setCharset(chartset);
        RequestConfig.Builder reqBuilder = RequestConfig.custom();
        reqBuilder.setExpectContinueEnabled(false);
        reqBuilder.setSocketTimeout(600000);
        reqBuilder.setConnectTimeout(600000);
        reqBuilder.setMaxRedirects(10);
        if (StringUtils.isNotBlank((CharSequence)proxyIp) && proxyPort > 0) {
            logger.info("using proxy {}:{} to request ", (Object)proxyIp, (Object)String.valueOf(proxyPort));
            HttpHost proxy = new HttpHost(proxyIp, proxyPort);
            reqBuilder.setProxy(proxy);
        }
        DefaultServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy = new DefaultServiceUnavailableRetryStrategy(3, 3000);
        builder.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)serviceUnavailableRetryStrategy);
        builder.setUserAgent("Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:50.0) Gecko/20100101 Firefox/50.0");
        builder.setDefaultRequestConfig(reqBuilder.build());
        builder.setDefaultConnectionConfig(connBuilder.build());
        builder.setConnectionManager(HttpClientUtil.getConnectionManager());
        return builder;
    }

    public static List<NameValuePair> getParamsList(Map<String, String> paramsMap) {
        if (paramsMap == null || paramsMap.size() == 0) {
            return null;
        }
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> map : paramsMap.entrySet()) {
            params.add((NameValuePair)new BasicNameValuePair(map.getKey(), map.getValue()));
        }
        return params;
    }

    public static String post(String url, Map<String, String> params) {
        return HttpClientUtil.post(url, params, CHARSET_UTF8);
    }

    public static String post(String url, Map<String, String> params, String charset) {
        return HttpClientUtil.post(url, params, charset, HttpClientUtil.getHttpClient(charset));
    }

    public static String post(String url, Map<String, String> params, String charset, boolean isSecure) {
        return HttpClientUtil.post(url, params, charset);
    }

    public static String post(String url, Map<String, String> params, String charset, CloseableHttpClient client) {
        if (url == null || StringUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        UrlEncodedFormEntity formEntity = null;
        try {
            if (charset == null || StringUtils.isEmpty((CharSequence)charset)) {
                if (null != params && params.size() > 0) {
                    formEntity = new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params));
                }
            } else if (null != params && params.size() > 0) {
                formEntity = new UrlEncodedFormEntity(HttpClientUtil.getParamsList(params), charset);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7f16\u7801\u96c6", e);
        }
        HttpPost hp = new HttpPost(url);
        if (null != formEntity) {
            hp.setEntity((HttpEntity)formEntity);
        }
        String responseStr = null;
        try {
            responseStr = (String)client.execute((HttpUriRequest)hp, responseHandler);
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("\u5ba2\u6237\u7aef\u8fde\u63a5\u534f\u8bae\u9519\u8bef", e);
        }
        catch (IOException e) {
            throw new RuntimeException("IO\u64cd\u4f5c\u5f02\u5e38", e);
        }
        finally {
            HttpClientUtil.abortConnection((HttpUriRequest)hp, client);
        }
        return responseStr;
    }
}

