/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.crypto;

import java.security.Provider;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AES {
    private static Logger logger = LoggerFactory.getLogger(AES.class);
    public static final String ALGORITHM = "AES";
    public static final String CIPHER_ALGORITHM = "AES/ECB/NoPadding";
    public static final String CHARSET = "UTF-8";

    public static byte[] decrypt(byte[] hexContentBytes, byte[] passwdBytes) {
        byte[] result = null;
        try {
            if (null == hexContentBytes || null == passwdBytes) {
                return result;
            }
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            SecretKeySpec key = new SecretKeySpec(passwdBytes, ALGORITHM);
            cipher.init(2, key);
            result = cipher.doFinal(hexContentBytes);
        }
        catch (Exception e) {
            logger.error("aes decrypt failed", (Throwable)e);
        }
        return result;
    }

    public static String decrypt(String content, String passwd) {
        String resultStr = "";
        try {
            if (StringUtils.isBlank((String)content) || StringUtils.isBlank((String)passwd)) {
                return resultStr;
            }
            byte[] data = Hex.decode((String)content);
            byte[] result = AES.decrypt(data, passwd.getBytes(CHARSET));
            resultStr = new String(result, CHARSET).trim();
        }
        catch (Exception e) {
            logger.error("aes decrypt failed", (Throwable)e);
        }
        return resultStr;
    }

    public static byte[] encrypt(byte[] hexContentBytes, byte[] passwdBytes) {
        byte[] result = null;
        try {
            if (null == hexContentBytes || null == passwdBytes) {
                return result;
            }
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            SecretKeySpec key = new SecretKeySpec(passwdBytes, ALGORITHM);
            cipher.init(1, key);
            int blockSize = cipher.getBlockSize();
            int orgLen = hexContentBytes.length;
            int requireLength = orgLen + blockSize - orgLen % blockSize;
            byte[] content = new byte[requireLength];
            System.arraycopy(hexContentBytes, 0, content, 0, orgLen);
            result = cipher.doFinal(content);
        }
        catch (Exception e) {
            logger.error("aes encrypt failed", (Throwable)e);
        }
        return result;
    }

    public static String encrypt(String content, String passwd) {
        String resultStr = "";
        try {
            if (StringUtils.isBlank((String)content) || StringUtils.isBlank((String)passwd)) {
                return resultStr;
            }
            byte[] result = AES.encrypt(content.getBytes(CHARSET), passwd.getBytes(CHARSET));
            resultStr = Hex.toHexString((byte[])result);
        }
        catch (Exception e) {
            logger.error("aes encrypt failed", (Throwable)e);
        }
        return resultStr;
    }

    public static void main(String[] args) throws Exception {
        String data = "851_1431483552157";
        String encodeData = "d117a2c889b728e123e7ac2bb933a29851a0a53d3f8ff70ed604d26538a8585a";
        String key = "c9539dacbe89eec252afa703f28ef06a";
        String r1 = AES.encrypt(data, key);
        logger.info("java encrypt r1: [{}] {} {}", new Object[]{r1, r1.equals(encodeData) ? "=" : "<>", encodeData});
        String r2 = AES.decrypt(encodeData, key);
        logger.info("java decrypt r2: [{}] {} {}", new Object[]{r2, r2.equals(data) ? "=" : "<>", data});
        logger.info("price in cent: {}", (Object)data.split("_", -1)[0]);
        data = "AES\u53ef\u4ee5\u4f7f\u7528128\u3001192\u3001\u548c256\u4f4d\u5bc6\u94a5";
        r1 = AES.encrypt(data, key);
        logger.info("java encrypt [{}][len={}] : [{}]", new Object[]{data, data.getBytes(CHARSET).length, r1});
        r2 = AES.decrypt(r1, key);
        logger.info("java encrypt [{}] {} [{}]", new Object[]{r2, r2.equals(data) ? "=" : "<>", data});
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

