/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.crypto;

import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import org.jiucai.appframework.common.encrypt.AbstractEncryptor;

public class DES
extends AbstractEncryptor {
    protected static String algorithmKey = "DES";

    public static String decode(String encryptResult, String password) {
        String result = null;
        byte[] decryptFrom = DES.hex2Byte(encryptResult);
        byte[] decryptResult = DES.decrypt(decryptFrom, password);
        if (null != decryptResult) {
            try {
                result = new String(decryptResult, charsetName);
            }
            catch (UnsupportedEncodingException e) {
                logger.error("decode failed", (Throwable)e);
            }
        }
        return result;
    }

    public static byte[] decrypt(byte[] src, String password) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes(charsetName));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithmKey);
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance(algorithmKey);
            cipher.init(2, (Key)securekey, random);
            return cipher.doFinal(src);
        }
        catch (Throwable e) {
            logger.error("decrypt failed", e);
            return null;
        }
    }

    public static String encode(String content, String password) {
        String result = null;
        byte[] encryptResult = DES.encrypt(content.getBytes(), password);
        if (null != encryptResult) {
            result = DES.byte2Hex(encryptResult);
        }
        return result;
    }

    public static byte[] encrypt(byte[] datasource, String password) {
        try {
            SecureRandom random = new SecureRandom();
            DESKeySpec desKey = new DESKeySpec(password.getBytes(charsetName));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithmKey);
            SecretKey securekey = keyFactory.generateSecret(desKey);
            Cipher cipher = Cipher.getInstance(algorithmKey);
            cipher.init(1, (Key)securekey, random);
            return cipher.doFinal(datasource);
        }
        catch (Throwable e) {
            logger.error("decrypt failed", e);
            return null;
        }
    }

    public static void main(String[] args) {
        String content = "DES\u52a0\u5bc6\u5b57\u7b26\u4e32\u6d4b\u8bd5by-jiucai";
        String password = "1234567890";
        System.out.println("\u52a0\u5bc6\u524d\uff1a" + content);
        String encodeStr = DES.encode(content, password);
        System.out.println("\u52a0\u5bc6\u540e\uff1a" + encodeStr);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + DES.decode(encodeStr, password));
    }
}

