/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.excel;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jiucai.appframework.base.util.DateTimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelReader {
    protected static Logger logger = LoggerFactory.getLogger(ExcelReader.class);
    protected static final String dateTimeFmtPattern = "yyyy-MM-dd HH:mm:ss";
    protected static final String dateFmtPattern = "yyyy-MM-dd";
    protected static final DataFormatter formatter = new DataFormatter();

    public static void main(String[] args) throws Exception {
        List<Map<String, String>> list = ExcelReader.read("e:/test1.xls");
        List<Map<String, String>> list2 = ExcelReader.read("e:/test1.xlsx");
        logger.info("list:\n" + list);
        logger.info("lis2t:\n" + list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> read(FileInputStream fis, String extension) throws Exception {
        HSSFWorkbook wb = null;
        List<Map<String, String>> list = null;
        try {
            if ("xls".equalsIgnoreCase(extension)) {
                wb = new HSSFWorkbook((InputStream)fis);
            } else if ("xlsx".equalsIgnoreCase(extension)) {
                wb = new XSSFWorkbook((InputStream)fis);
            } else {
                logger.error("file is not office excel");
                throw new IllegalArgumentException("file is not office excel");
            }
            List<Map<String, String>> list2 = list = ExcelReader.readWorkbook((Workbook)wb);
            return list2;
        }
        finally {
            if (null != wb) {
                wb.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Map<String, String>> read(String fileName) throws Exception {
        FileInputStream fis = null;
        Object wb = null;
        List<Map<String, String>> list = null;
        try {
            String extension = FilenameUtils.getExtension((String)fileName);
            fis = new FileInputStream(fileName);
            List<Map<String, String>> list2 = list = ExcelReader.read(fis, extension);
            return list2;
        }
        finally {
            if (null != wb) {
                wb.close();
            }
            if (null != fis) {
                fis.close();
            }
        }
    }

    private static String formatDate(Date d, String sdf) {
        String value = null;
        value = d.getSeconds() == 0 && d.getMinutes() == 0 && d.getHours() == 0 ? DateTimeUtil.getFormatedDate(d, dateFmtPattern) : DateTimeUtil.getFormatedDate(d, sdf);
        return value;
    }

    protected static String getCellValue(Cell cell) {
        String value = null;
        switch (cell.getCellType()) {
            case 0: 
            case 2: {
                double doubleVal = cell.getNumericCellValue();
                short format = cell.getCellStyle().getDataFormat();
                String formatString = cell.getCellStyle().getDataFormatString();
                if (format > 0) {
                    logger.info("format: " + format + "\u3000formatString: " + formatString);
                }
                if (format == 14 || format == 31 || format == 57 || format == 58 || format >= 176 && format <= 183) {
                    Date date = DateUtil.getJavaDate((double)doubleVal);
                    value = ExcelReader.formatDate(date, dateFmtPattern);
                    break;
                }
                if (format == 20 || format == 32 || format >= 184 && format <= 187) {
                    Date date = DateUtil.getJavaDate((double)doubleVal);
                    value = ExcelReader.formatDate(date, "HH:mm");
                    break;
                }
                value = String.valueOf(doubleVal);
                break;
            }
            case 1: {
                value = cell.getStringCellValue();
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
            default: {
                value = "";
            }
        }
        return value;
    }

    protected static List<Map<String, String>> readWorkbook(Workbook wb) throws Exception {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        for (int k = 0; k < wb.getNumberOfSheets(); ++k) {
            Sheet sheet = wb.getSheetAt(k);
            int rows = sheet.getPhysicalNumberOfRows();
            for (int r = 0; r < rows; ++r) {
                Row row = sheet.getRow(r);
                if (row == null) continue;
                HashMap<String, String> map = new HashMap<String, String>();
                int cells = row.getPhysicalNumberOfCells();
                for (int c = 0; c < cells; ++c) {
                    Cell cell = row.getCell(c);
                    if (cell == null) continue;
                    String value = ExcelReader.getCellValue(cell);
                    map.put(String.valueOf(cell.getColumnIndex() + 1), value);
                }
                list.add(map);
            }
        }
        return list;
    }
}

