/*
 * Decompiled with CFR 0.152.
 */
package org.jiucai.appframework.common.encrypt;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSecretKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.bc.BcPGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

public abstract class AbstractPGPEncryptor {
    protected static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        ((InputStream)is).close();
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        return bytes;
    }

    protected static PGPPublicKey readPublicKey(InputStream in) throws IOException, PGPException {
        BcPGPPublicKeyRingCollection pgpPub = new BcPGPPublicKeyRingCollection(PGPUtil.getDecoderStream((InputStream)in));
        in.close();
        Iterator rIt = pgpPub.getKeyRings();
        while (rIt.hasNext()) {
            PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
            Iterator kIt = kRing.getPublicKeys();
            while (kIt.hasNext()) {
                PGPPublicKey k = (PGPPublicKey)kIt.next();
                if (!k.isEncryptionKey()) continue;
                return k;
            }
        }
        throw new IllegalArgumentException("Can't find encryption key in key ring.");
    }

    protected static PGPPublicKey readPublicKey(String fileName) throws IOException, PGPException {
        BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(fileName));
        PGPPublicKey pubKey = AbstractPGPEncryptor.readPublicKey(keyIn);
        ((InputStream)keyIn).close();
        return pubKey;
    }

    protected static PGPSecretKey readSecretKey(InputStream input) throws IOException, PGPException {
        PGPSecretKeyRingCollection pgpSec = new PGPSecretKeyRingCollection(PGPUtil.getDecoderStream((InputStream)input), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
        input.close();
        Iterator keyRingIter = pgpSec.getKeyRings();
        while (keyRingIter.hasNext()) {
            PGPSecretKeyRing keyRing = (PGPSecretKeyRing)keyRingIter.next();
            Iterator keyIter = keyRing.getSecretKeys();
            while (keyIter.hasNext()) {
                PGPSecretKey key = (PGPSecretKey)keyIter.next();
                if (!key.isSigningKey()) continue;
                return key;
            }
        }
        throw new IllegalArgumentException("Can't find signing key in key ring.");
    }

    protected static PGPSecretKey readSecretKey(String fileName) throws IOException, PGPException {
        BufferedInputStream keyIn = new BufferedInputStream(new FileInputStream(fileName));
        PGPSecretKey secKey = AbstractPGPEncryptor.readSecretKey(keyIn);
        ((InputStream)keyIn).close();
        return secKey;
    }
}

